/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.util.FileUtils;
import org.apache.log4j.Logger;

public class RepositoryFileManager {
    private static Logger logger;
    private String path;

    public RepositoryFileManager(String pathName) {
        this.path = pathName;
        logger = Logger.getLogger((String)this.getClass().getName());
    }

    public int getLinesOfCode(String filename) throws NoLineCountException {
        String absoluteName = FileUtils.getAbsoluteName(this.path, filename);
        try {
            FileReader freader = new FileReader(absoluteName);
            BufferedReader reader = new BufferedReader(freader);
            int linecount = this.getLineCount(reader);
            logger.debug((Object)("line count for '" + absoluteName + "': " + linecount));
            freader.close();
            return linecount;
        }
        catch (IOException e) {
            throw new NoLineCountException("could not get line count for '" + absoluteName + "': " + e);
        }
    }

    private int getLineCount(BufferedReader reader) throws IOException {
        int linecount = 0;
        while (reader.readLine() != null) {
            ++linecount;
        }
        return linecount;
    }
}

