/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private String methodName = "";
    private int paramCount = 0;

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.methodName = this.getFirstToken().image;
        this.paramCount = this.jjtGetNumChildren() - 1;
        return data;
    }

    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        VelMethod method = null;
        Object[] params = new Object[this.paramCount];
        try {
            int j;
            IntrospectionCacheData icd = context.icacheGet(this);
            Class<?> c = o.getClass();
            if (icd != null && icd.contextData == c) {
                for (j = 0; j < this.paramCount; ++j) {
                    params[j] = this.jjtGetChild(j + 1).value(context);
                }
                method = (VelMethod)icd.thingy;
            } else {
                for (j = 0; j < this.paramCount; ++j) {
                    params[j] = this.jjtGetChild(j + 1).value(context);
                }
                method = this.rsvc.getUberspect().getMethod(o, this.methodName, params, new Info("", 1, 1));
                if (method != null) {
                    icd = new IntrospectionCacheData(method, c);
                    context.icachePut(this, icd);
                }
            }
            if (method == null) {
                return null;
            }
        }
        catch (MethodInvocationException mie) {
            throw mie;
        }
        catch (Exception e) {
            this.rsvc.error("ASTMethod.execute() : exception from introspection : " + e);
            return null;
        }
        try {
            Object obj = method.invoke(o, params);
            if (obj == null && method.getReturnType() == Void.TYPE) {
                return new String("");
            }
            return obj;
        }
        catch (InvocationTargetException ite) {
            EventCartridge ec = context.getEventCartridge();
            if (ec != null && ite.getTargetException() instanceof Exception) {
                try {
                    return ec.methodException(o.getClass(), this.methodName, (Exception)ite.getTargetException());
                }
                catch (Exception e) {
                    throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + e.getClass() + " : " + e.getMessage(), e, this.methodName);
                }
            }
            throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + ite.getTargetException().getClass() + " : " + ite.getTargetException().getMessage(), ite.getTargetException(), this.methodName);
        }
        catch (Exception e) {
            this.rsvc.error("ASTMethod.execute() : exception invoking method '" + this.methodName + "' in " + o.getClass() + " : " + e);
            return null;
        }
    }
}

