/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.carol.util.multi.ProtocolCurrent;

public class MultiOrbInitialContext
implements Context {
    private ProtocolCurrent pcur = null;
    private Hashtable activesInitialsContexts = null;
    private String rmiName = null;

    public MultiOrbInitialContext() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.MultiOrbInitialContext()");
        }
        try {
            this.pcur = ProtocolCurrent.getCurrent();
            this.activesInitialsContexts = this.pcur.getNewContextHashtable();
        }
        catch (Exception e) {
            String msg = "MultiOrbInitialContext.MultiOrbInitialContext() failed: " + e;
            throw new NamingException(msg);
        }
    }

    public Object lookup(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.lookup(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().lookup(this.encode(name));
        }
        catch (NamingException e) {
            String msg = e.getMessage();
            if (TraceCarol.isDebugJndiCarol()) {
                msg = "MultiOrbInitialContext.lookup(\"" + name + "\") failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw new NamingException(msg);
        }
    }

    public Object lookup(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.lookup(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().lookup(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.lookup(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.bind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).bind(this.encode(name), obj);
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.bind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.bind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).bind(this.encode(name), obj);
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.bind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.rebind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rebind(this.encode(name), obj);
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.rebind(String name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.rebind(\"" + name + "\"," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rebind(this.encode(name), obj);
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.rebind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.unbind(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).unbind(this.encode(name));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.unbind(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.unbind(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).unbind(this.encode(name));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.unbind(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.rename(\"" + oldName + "\",\"" + newName + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rename(this.encode(oldName), this.encode(newName));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.rename(String oldName, String newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.rename(\"" + oldName + "\",\"" + newName + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rename(this.encode(oldName), this.encode(newName));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.rename(Name oldName, Name newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.list(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return new WrapEnum(this.pcur.getCurrentInitialContext().list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.list(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.list(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return new WrapEnum(this.pcur.getCurrentInitialContext().list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.list(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.listBindings(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return new WrapEnum(this.pcur.getCurrentInitialContext().list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.listBindings(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.listBindings(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return new WrapEnum(this.pcur.getCurrentInitialContext().list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.listBindings(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.destroySubcontext(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).destroySubcontext(this.encode(name));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.destroySubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.destroySubcontext(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).destroySubcontext(this.encode(name.toString()));
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.destroySubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.createSubcontext(\"" + name + "\")");
        }
        try {
            return this.pcur.getCurrentInitialContext().createSubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.createSubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.createSubcontext(\"" + name + "\")");
        }
        try {
            return this.pcur.getCurrentInitialContext().createSubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.createSubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.lookupLink(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().lookupLink(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.lookupLink(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.lookupLink(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().lookupLink(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.lookupLink(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.getNameParser(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.getNameParser(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.getNameParser(\"" + name + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.getNameParser(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.composeName(" + name + "," + prefix + ")/rmi name=" + this.pcur.getCurrentRMIName());
        }
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.composeName(\"" + name + "," + prefix + "\")/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        return this.pcur.getCurrentInitialContext().composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        try {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("MultiOrbInitialContext.addToEnvironment(\"" + propName + "\"," + this.simpleClass(propVal.getClass().getName()) + " object)");
            }
            return this.pcur.getCurrentInitialContext().addToEnvironment(propName, propVal);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.addToEnvironment(String propName, Object propVal)  failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.removeFromEnvironment(\"" + propName + "\")");
        }
        try {
            return this.pcur.getCurrentInitialContext().removeFromEnvironment(propName);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.removeFromEnvironment(String propName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.getEnvironment()/rmi name=\"" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().getEnvironment();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.getEnvironment() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void close() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.close()");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.pcur.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).close();
                this.pcur.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.close() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String getNameInNamespace() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiOrbInitialContext.getNameInNamespace()/rmi name=" + this.pcur.getCurrentRMIName() + "\"");
        }
        try {
            return this.pcur.getCurrentInitialContext().getNameInNamespace();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiOrbInitialContext.getNameInNamespace() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    private String simpleClass(String c) {
        return c.substring(c.lastIndexOf(46) + 1);
    }

    private String encode(String name) {
        if (name.length() < 1) {
            return name;
        }
        StringBuffer newname = new StringBuffer(name);
        int i = 0;
        while (i < newname.length()) {
            char c = newname.charAt(i);
            if (c == '/' || c == '\\') {
                newname.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        if (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') {
            newname.insert(0, '\\');
        }
        return newname.toString();
    }

    private String decode(String name) {
        StringBuffer newname = new StringBuffer(name);
        if (newname.length() >= 2 && (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') && newname.charAt(0) == newname.charAt(newname.length() - 1)) {
            newname.deleteCharAt(0);
            newname.deleteCharAt(newname.length() - 1);
        } else {
            if (name.indexOf(92) < 0) {
                return name;
            }
            int i = 0;
            while (i < newname.length()) {
                if (newname.charAt(i) == '\\') {
                    newname.deleteCharAt(i);
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        return newname.toString();
    }

    private Name encode(Name name) {
        try {
            return new CompositeName(this.encode(name.toString()));
        }
        catch (InvalidNameException e) {
            return name;
        }
    }

    private Name decode(Name name) {
        try {
            return new CompositeName(this.decode(name.toString()));
        }
        catch (InvalidNameException e) {
            return name;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WrapEnum
    implements NamingEnumeration {
        NamingEnumeration enum;

        WrapEnum(NamingEnumeration names) {
            this.enum = names;
        }

        public boolean hasMoreElements() {
            return this.enum.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.enum.hasMore();
        }

        public Object nextElement() {
            NameClassPair ncp = (NameClassPair)this.enum.nextElement();
            ncp.setName(MultiOrbInitialContext.this.decode(ncp.getName()));
            return ncp;
        }

        public Object next() throws NamingException {
            NameClassPair ncp = (NameClassPair)this.enum.next();
            ncp.setName(MultiOrbInitialContext.this.decode(ncp.getName()));
            return ncp;
        }

        public void close() throws NamingException {
            this.enum = null;
        }
    }
}

