/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.carol.cmi.compiler.Compiler;
import org.objectweb.carol.cmi.compiler.CompilerException;
import org.objectweb.carol.cmi.compiler.MethodConf;
import org.objectweb.carol.cmi.compiler.MethodProto;

public class ClassConf {
    private HashMap mthInfos = new HashMap();
    private boolean lookupChoice = false;
    private ArrayList rrList = new ArrayList();
    private ArrayList randList = new ArrayList();
    private int balancerNo = 0;
    private String defaultBalancer = null;
    private Class cl;

    public ClassConf(Class cl) {
        this.cl = cl;
    }

    public String getClassName() {
        return this.cl.getName();
    }

    public boolean containsMethod(MethodProto mp) {
        return this.mthInfos.containsKey(mp);
    }

    public void putMethod(MethodProto mp, MethodConf cmc) {
        this.mthInfos.put(mp, cmc);
    }

    public Iterator getMethodConfs() {
        return this.mthInfos.values().iterator();
    }

    public void setLookupChoice() {
        this.lookupChoice = true;
    }

    public MethodConf getMethodConf(MethodProto mp) throws CompilerException {
        MethodConf cmc = (MethodConf)this.mthInfos.get(mp);
        if (cmc == null) {
            throw new CompilerException("No configuration found for method " + mp + " in class " + this.getClassName());
        }
        return cmc;
    }

    public String getRemoteItfString() {
        Iterator it = Compiler.getRemoteItfs(this.cl).iterator();
        String s = "";
        while (it.hasNext()) {
            Class itf = (Class)it.next();
            s = s.equals("") ? itf.getName() : s + ", " + itf.getName();
        }
        return s;
    }

    public String addRR() {
        String s = "rr" + this.balancerNo;
        ++this.balancerNo;
        this.rrList.add(s);
        return s;
    }

    public String addRandom() {
        String s = "rand" + this.balancerNo;
        ++this.balancerNo;
        this.randList.add(s);
        return s;
    }

    public ArrayList getRR() {
        return this.rrList;
    }

    public ArrayList getRandom() {
        return this.randList;
    }

    public String getBalancer() {
        if (this.defaultBalancer == null) {
            this.defaultBalancer = "balancer";
        }
        this.randList.add(this.defaultBalancer);
        return this.defaultBalancer;
    }

    public void validate() throws CompilerException {
        MethodConf mc;
        Method[] m = Compiler.getRemoteMethods(this.cl);
        if (m.length == 0) {
            throw new CompilerException("class " + this.cl + " does not implement remote methods");
        }
        int i = 0;
        while (i < m.length) {
            MethodProto mp = new MethodProto(m[i]);
            mc = (MethodConf)this.mthInfos.get(mp);
            if (mc == null) {
                throw new CompilerException("no configuration given for method " + mp);
            }
            mc.setMethod(m[i]);
            ++i;
        }
        Iterator it = this.getMethodConfs();
        while (it.hasNext()) {
            mc = (MethodConf)it.next();
            if (mc.getMethod() != null) continue;
            throw new CompilerException("class " + mc.getClassConf().getClassName() + " has no method " + mc.getMethodProto());
        }
    }
}

