/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.PluginResource;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/resources";
    private final String resourceName;
    private final String moduleCompleteKey;
    private final boolean cached;
    private final Map<String, String> params;

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached) {
        this(resourceName, moduleCompleteKey, cached, Collections.emptyMap());
    }

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached, Map<String, String> params) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.cached = cached;
        this.params = params;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public boolean isCacheSupported() {
        return this.cached;
    }

    @Override
    public String getUrl() {
        return "/download/resources/" + this.moduleCompleteKey + "/" + this.resourceName;
    }

    public static boolean matches(String url) {
        return url.indexOf(URL_PREFIX) != -1;
    }

    public static SinglePluginResource parse(String url) {
        String[] parts;
        int indexOfPrefix = url.indexOf(URL_PREFIX);
        String libraryAndResource = url.substring(indexOfPrefix + URL_PREFIX.length() + 1);
        if (libraryAndResource.indexOf(63) != -1) {
            libraryAndResource = libraryAndResource.substring(0, libraryAndResource.indexOf(63));
        }
        if ((parts = libraryAndResource.split("/", 2)).length != 2) {
            return null;
        }
        return new SinglePluginResource(parts[1], parts[0], url.substring(0, indexOfPrefix).length() > 0);
    }
}

