/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.FileUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtils {
    private static final Logger log = Logger.getLogger(PropertyUtils.class);

    public static Properties getProperties(String resource, Class callingClass) {
        return PropertyUtils.getPropertiesFromStream(ClassLoaderUtils.getResourceAsStream(resource, callingClass));
    }

    public static Properties getPropertiesFromFile(File file) {
        try {
            return PropertyUtils.getPropertiesFromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error loading properties from file: " + file.getPath() + ". File does not exist."), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            log.error((Object)"Error loading properties from stream.", (Throwable)e);
        }
        finally {
            FileUtils.shutdownStream(is);
        }
        return props;
    }

    public static boolean identical(PropertySet pThis, PropertySet pThat) {
        Collection thatKeys;
        if (pThis == null && pThat == null) {
            return true;
        }
        if (pThis == null || pThat == null) {
            return false;
        }
        Collection thisKeys = pThis.getKeys();
        if (!thisKeys.containsAll(thatKeys = pThat.getKeys()) || !thatKeys.containsAll(thisKeys)) {
            return false;
        }
        for (String key : thisKeys) {
            int keyType = pThis.getType(key);
            if (1 == keyType) {
                if (pThis.getBoolean(key) == pThat.getBoolean(key)) continue;
                return false;
            }
            if (10 == keyType) {
                throw new IllegalArgumentException("DATA Comparision has not been implemented in PropertyUtil");
            }
            if (7 == keyType) {
                if (pThis.getDate(key).equals(pThat.getDate(key))) continue;
                return false;
            }
            if (4 == keyType) {
                if (pThis.getDouble(key) == pThat.getDouble(key)) continue;
                return false;
            }
            if (2 == keyType) {
                if (pThis.getInt(key) == pThat.getInt(key)) continue;
                return false;
            }
            if (8 == keyType) {
                throw new IllegalArgumentException("OBJECT Comparision has not been implemented in PropertyUtil");
            }
            if (11 == keyType) {
                throw new IllegalArgumentException("PROPERTIES Comparision has not been implemented in PropertyUtil");
            }
            if (3 == keyType) {
                if (pThis.getLong(key) == pThat.getLong(key)) continue;
                return false;
            }
            if (5 == keyType) {
                if (pThis.getString(key).equals(pThat.getString(key))) continue;
                return false;
            }
            if (6 == keyType) {
                if (pThis.getText(key).equals(pThat.getText(key))) continue;
                return false;
            }
            if (9 != keyType) continue;
            throw new IllegalArgumentException("XML Comparision has not been implemented in PropertyUtil");
        }
        return true;
    }
}

