<%@ taglib prefix="ww" uri="webwork" %>
<%@ taglib prefix="aui" uri="webwork" %>
<%@ taglib prefix="page" uri="sitemesh-page" %>
<html>
<head>
    <ww:if test="/canDelete == true"><meta content="genericaction" name="decorator"/></ww:if>
    <ww:else><meta content="message" name="decorator" /></ww:else>
</head>
<body class="type-a">
<ww:if test="canDelete == true">
    <div class="content intform">
        <page:applyDecorator id="delete-portal-page" name="auiform">
            <page:param name="action">DeletePortalPage.jspa</page:param>
            <page:param name="cssClass">delete-portal-page-<ww:property value="pageId" /></page:param>
            <page:param name="submitButtonName">Delete</page:param>
            <page:param name="submitButtonText"><ww:text name="'common.words.delete'"/></page:param>
            <%-- This cancelLinkURI is only used when you are coming from the manage dashboards page, the actual
            dashboard pages override this value by appending a magical returnUrl parameter to the link to open this page --%>
            <page:param name="cancelLinkURI"><ww:url value="'/secure/ConfigurePortalPages!default.jspa'" atltoken="false"/></page:param>
            <aui:component name="'targetUrl'" value="/targetUrl" template="hidden.jsp" theme="'aui'"/>

            <aui:component template="formHeading.jsp" theme="'aui'">
                <aui:param name="'text'"><ww:text name="'portal.deletepage.title'"><ww:param name="'value0'"><ww:property value="pageName" /></ww:param></ww:text></aui:param>
            </aui:component>

            <aui:component template="formDescriptionBlock.jsp" theme="'aui'">
                <aui:param name="'messageHtml'">
                    <p><ww:text name="'portal.deletepage.confirm.desc'"/></p>
                    <ww:if test="otherFavouriteCount > 0">
                        <p id="otherFavouriteCount">
                            <ww:if test="otherFavouriteCount == 1">
                                <ww:text name="'deletefilter.other.favourite.filter.one'"/>
                            </ww:if>
                            <ww:elseIf test="otherFavouriteCount > 1">
                                <ww:text name="'deletefilter.other.favourite.filter.many'">
                                    <ww:param name="'value0'"><ww:property value="otherFavouriteCount"/></ww:param>
                                </ww:text>
                            </ww:elseIf>
                        </p>
                    </ww:if>
                </aui:param>
            </aui:component>

            <aui:component name="'pageId'" template="hidden.jsp" theme="'aui'" />

        </page:applyDecorator>
    </div>
</ww:if>
<ww:else>
    <div class="content-body jira-error">
        <h1><ww:text name="'portal.deletepage.can.not.delete'" /></h1>
        <aui:component template="auimessage.jsp" theme="'aui'">
            <aui:param name="'messageType'">error</aui:param>
            <aui:param name="'messageHtml'">
                <ww:if test="hasErrorMessages == 'true'">
                    <ww:iterator value="flushedErrorMessages">
                        <p><ww:property value="." /></p>
                    </ww:iterator>
                </ww:if>
            </aui:param>
        </aui:component>
    </div>
</ww:else>
</body>
</html>
