<%@ taglib uri="webwork" prefix="ww" %>
<%@ taglib uri="webwork" prefix="aui" %>
<%@ taglib uri="jiratags" prefix="jira" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>

<html>
<head>
	<title><ww:text name="'common.concepts.managefilters'"/></title>
    <content tag="section">find_link</content>
</head>
<body class="nl iss-nav">

    <div class="item-header">
        <ww:if test="(/hasAnyErrors == false && /searchResults) || /mode == 'hide'">
            <jsp:include page="/includes/navigator/table/header.jsp"/>
        </ww:if>
        <ww:else>
            <h1 class="item-summary">
                <ww:property value="text('navigator.title')"/><ww:if test="searchRequest/name"> &mdash; <ww:property value="searchRequest/name"/></ww:if>
            </h1>
        </ww:else>
    </div>
    <div id="iss-wrap" <ww:if test="/conglomerateCookieValue('jira.toggleblocks.cong.cookie','lhc-state')/contains('#iss-wrap') == true">class="lhc-collapsed"</ww:if>>
        <div id="main-content">
            <div class="column" id="primary" >
            <a class="toggle-lhc" href="#" title="<ww:text name="'jira.issuenav.toggle.lhc'" />"><ww:text name="'jira.issuenav.toggle.lhc'" /></a>
                <div class="content rounded">
                    <jsp:include page="/includes/navigator/summary-pane.jsp" />
                </div>
            </div>
            <div class="column" id="secondary">
                <div class="content rounded">

                    <page:applyDecorator name="jirapanel">
                        <page:param name="title">
                            <ww:text name="'subscriptions.title'"><ww:param name="'value0'"><ww:property value="filterName"/></ww:param></ww:text>
                        </page:param>
                        <page:param name="description">
                            <ww:text name="'subscriptions.list'"/>.<br>

                            <a href="<ww:url value="'FilterSubscription!default.jspa'"><ww:param name="'filterId'" value="filterId" /></ww:url>"><b><ww:text name="'subscriptions.add'"/></b></a><br>

                            <ww:text name="'subscriptions.viewAllFilters'">
                                <ww:param name="'value0'"><a href="<ww:url page="ManageFilters.jspa"/>"><b></ww:param>
                                <ww:param name="'value1'"></b></a></ww:param>
                            </ww:text>
                            <ww:if test="mailConfigured == false && subscriptionCount > 0">
                                <aui:component template="auimessage.jsp" theme="'aui'">
                                    <aui:param name="'messageType'">warning</aui:param>
                                    <aui:param name="'messageHtml'">
                                        <p><ww:text name="'filters.no.mail.configured'"/></p>
                                    </aui:param>
                                </aui:component>
                            </ww:if>
                        </page:param>
                        <page:param name="width">100%</page:param>
                    </page:applyDecorator>


                    <table class="aui" border="0" cellpadding="0" cellspacing="0">
                        <thead>
                            <tr>
                                <th>
                                    <ww:text name="'subscriptions.subscriber'"/>
                                </th>
                                <th>
                                    <ww:text name="'subscriptions.subscribed'"/>
                                </th>
                                <th>
                                    <ww:text name="'filtersubscription.field.schedule'"/>
                                    <ww:component name="'issue_filters_subscribing'" template="help.jsp">
                                        <ww:param name="'noalign'" value="'true'"/>
                                    </ww:component>
                                </th>
                                <th>
                                    <ww:text name="'subscriptions.lastSent'"/>
                                </th>
                                <th>
                                    <ww:text name="'subscriptions.nextSend'"/>
                                </th>
                                <th>
                                    <ww:text name="'common.words.operations'"/>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <ww:if test="subscriptions != null && subscriptions/size > 0">
                                <ww:iterator value="subscriptions" status="'status'">
                                <tr bgcolor="#<ww:if test="@status/modulus(2) == 1">ffffff</ww:if><ww:else>fffff0</ww:else>">
                                    <td width=25%>
                                        <ww:property value="string('username')"/>
                                    </td>
                                    <td width=25%>
                                        <ww:if test="string('group') != null && string('group')/length > 0">
                                                <ww:if test="/groupValid(.) == false"><span class="warning" title="<ww:text name="'admin.projects.group.invalid'"/>"></ww:if>
                                                <ww:property value="string('group')"/>
                                                <ww:if test="/groupValid(.) == false"></span></ww:if>
                                        </ww:if>
                                        <ww:else>
                                                <ww:property value="string('username')"/>
                                        </ww:else>
                                    </td>
                                    <td nowrap><span title="<ww:property value="/cronTooltip(.)"/>"><ww:property value="prettySchedule(.)" /></span></td>
                                    <td nowrap><ww:property value="lastSent(.)" /></td>
                                    <td nowrap><ww:property value="nextSend(.)" /></td>
                                    <td width=1% nowrap>
                                    <ww:if test="remoteUser/name == string('username')" >
                                        <a id="edit_subscription" href="<ww:url value="'FilterSubscription!default.jspa'"><ww:param name="'subId'" value="long('id')" /><ww:param name="'filterId'" value="filterId" /></ww:url>"><ww:text name="'common.words.edit'"/></a>
                                        | <a href="<ww:url value="'DeleteSubscription.jspa'"><ww:param name="'subId'" value="long('id')" /><ww:param name="'filterId'" value="filterId" /></ww:url>"><ww:text name="'common.words.delete'"/></a>
                                        <ww:if test="mailConfigured == true">
                                        | <a href="<ww:url value="'RunSubscription.jspa'"><ww:param name="'subId'" value="long('id')" /><ww:param name="'filterId'" value="filterId" /></ww:url>"><ww:text name="'common.forms.run.now'"/></a>
                                        </ww:if>
                                    </ww:if>
                                    </td>
                                </tr>
                                </ww:iterator>
                            </ww:if>
                            <ww:else>
                                <tr>
                                    <td colspan="6">
                                        <aui:component template="auimessage.jsp" theme="'aui'">
                                            <aui:param name="'messageType'">info</aui:param>
                                            <aui:param name="'messageHtml'">
                                                <p><ww:text name="'subscriptions.nosubs'"/></p>
                                            </aui:param>
                                        </aui:component>
                                    </td>
                                </tr>
                            </ww:else>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</body>
</html>
