<%@ taglib uri="webwork" prefix="ww"  %>
<%@ taglib uri="webwork" prefix="aui"  %>
<%@ taglib uri="sitemesh-page" prefix="page" %>


<html>
<head>
	<title><ww:text name="'admin.loggingandprofiling.logging.and.profiling'"/></title>
    <meta name="admin.active.section" content="admin_system_menu/top_system_section/troubleshooting_and_support"/>
    <meta name="admin.active.tab" content="logging_profiling"/>
</head>

<body>

<%--
   General Logging Section

   Part of JRA-14513
--%>
<%-- error messages --%>
<ww:if test="hasErrorMessages == 'true'">
    <aui:component template="auimessage.jsp" theme="'aui'">
        <aui:param name="'messageType'">error</aui:param>
        <aui:param name="'titleText'"><ww:text name="'admin.common.words.errors'"/></aui:param>
        <aui:param name="'messageHtml'">
            <ul>
                <ww:iterator value="errorMessages">
                    <li><ww:property /></li>
                </ww:iterator>
            </ul>
        </aui:param>
    </aui:component>
</ww:if>

<div class="logging-container">
    <h3 class="formtitle"><ww:text name="'admin.loggingandprofiling.logging'"/></h3>
    <p><ww:text name="'admin.loggingandprofiling.description'"/></p>
    <p>
    <ww:text name="'admin.loggingandprofiling.note'">
        <ww:param name="'value0'"><i></ww:param>
        <ww:param name="'value1'"></i></ww:param>
        <ww:param name="'value2'"><br></ww:param>
    </ww:text>
    </p>
    <p><ww:text name="'admin.loggingandprofiling.logging.will.go.to.the.console'"/></p>


    <table class="aui aui-table-rowhover">
        <thead>
            <tr>
                <th><ww:text name="'admin.loggingandprofiling.package.name'"/></th>
                <th><ww:text name="'admin.loggingandprofiling.logging.level'"/></th>
                <th><ww:text name="'admin.loggingandprofiling.set.logging.level'"/></th>
            </tr>
        </thead>
        <tbody>
        <ww:property value="/rootLogger" >
            <tr>
                <td><i><ww:text name="'admin.common.words.default'"/></i></td>
                <td><strong><ww:property value="./level" /></strong></td>
                <td><jsp:include page="viewlogginglevels.jsp"/></td>
            </tr>
        </ww:property>
        <ww:iterator value="/loggers" status="'iteratorStatus'">
            <tr>
                <td><ww:property value="name" /></td>
                <td><strong><ww:property value="./level" /></strong></td>
                <td><jsp:include page="viewlogginglevels.jsp"/></td>
            </tr>
        </ww:iterator>
        </tbody>
    </table>
</div>
<%--
   HTTP Access Log Section
--%>
<div class="logging-container">
    <a name="http"></a>
    <h3 class="formtitle"><ww:text name="'admin.loggingandprofiling.httpaccesslog'"/></h3>
    <p><ww:text name="'admin.loggingandprofiling.httpaccesslog.description'"/></p>

    <ww:if test="/httpAccessLogEnabled == true">
        <p>
        <ww:text name="'admin.loggingandprofiling.httpaccesslog.status'">
            <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.disable.httpaccesslog'">
                    <ww:param name="'value0'"><a id="disable_http_access" href="ViewLogging!disableHttpAccessLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
        <div style="padding-left:2em">

        <ww:if test="/httpAccessLogIncludeImagesEnabled == true">
            <p>
            <ww:text name="'admin.loggingandprofiling.httpaccesslog.includeimages.status'">
                <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                <ww:text name="'admin.loggingandprofiling.disable.httpaccesslog.includeimages'">
                    <ww:param name="'value0'"><a id="disable_http_access_includeimages" href="ViewLogging!disableHttpAccessLogIncludeImages.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
                </li>
            </ul>
        </ww:if>
        <ww:else>
            <p>
            <ww:text name="'admin.loggingandprofiling.httpaccesslog.includeimages.status'">
                <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                <ww:text name="'admin.loggingandprofiling.enable.httpaccesslog.includeimages'">
                    <ww:param name="'value0'"><a id="enable_http_access_includeimages" href="ViewLogging!enableHttpAccessLogIncludeImages.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
                </li>
            </ul>
        </ww:else>


        <ww:if test="/httpDumpLogEnabled == true">
            <p>
            <ww:text name="'admin.loggingandprofiling.httpdumplog.status'">
                <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                <ww:text name="'admin.loggingandprofiling.disable.httpdumplog'">
                    <ww:param name="'value0'"><a id="disable_http_dump" href="ViewLogging!disableHttpDumpLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
                </li>
            </ul>
        </ww:if>
        <ww:else>
            <p>
            <ww:text name="'admin.loggingandprofiling.httpdumplog.status'">
                <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                <ww:text name="'admin.loggingandprofiling.enable.httpdumplog'">
                    <ww:param name="'value0'"><a id="enable_http_dump" href="ViewLogging!enableHttpDumpLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
                </li>
            </ul>
        </ww:else>
        </div>

    </ww:if>
    <ww:else>
        <p>
        <ww:text name="'admin.loggingandprofiling.httpaccesslog.status'">
            <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.enable.httpaccesslog'">
                    <ww:param name="'value0'"><a id="enable_http_access" href="ViewLogging!enableHttpAccessLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
    </ww:else>
</div>

<%--
   SOAP Access Log Section
--%>
<div class="logging-container">
    <a name="soap"></a>
    <h3 class="formtitle"><ww:text name="'admin.loggingandprofiling.soapaccesslog'"/></h3>
    <p><ww:text name="'admin.loggingandprofiling.soapaccesslog.description'"/></p>
    <ww:if test="/soapAccessLogEnabled == true">
        <p>
        <ww:text name="'admin.loggingandprofiling.soapaccesslog.status'">
            <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.disable.soapaccesslog'">
                    <ww:param name="'value0'"><a id="disable_soap_access" href="ViewLogging!disableSoapAccessLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
        <div style="padding-left:2em">
        <ww:if test="/soapDumpLogEnabled == true">
            <p>
            <ww:text name="'admin.loggingandprofiling.soapdumplog.status'">
                <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                    <ww:text name="'admin.loggingandprofiling.disable.soapdumplog'">
                        <ww:param name="'value0'"><a id="disable_soap_dump" href="ViewLogging!disableSoapDumpLog.jspa"><b></ww:param>
                        <ww:param name="'value1'"></b></a></ww:param>
                    </ww:text>
                </li>
            </ul>
        </ww:if>
        <ww:else>
            <p>
            <ww:text name="'admin.loggingandprofiling.soapdumplog.status'">
                <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
            </ww:text>
            </p>
            <ul class="optionslist">
                <li>
                    <ww:text name="'admin.loggingandprofiling.enable.soapdumplog'">
                       <ww:param name="'value0'"><a id="enable_soap_dump" href="ViewLogging!enableSoapDumpLog.jspa"><b></ww:param>
                       <ww:param name="'value1'"></b></a></ww:param>
                    </ww:text>
                </li>
            </ul>
        </ww:else>
        </div>
    </ww:if>
    <ww:else>
        <p>
        <ww:text name="'admin.loggingandprofiling.soapaccesslog.status'">
            <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.enable.soapaccesslog'">
                    <ww:param name="'value0'"><a id="enable_soap_access" href="ViewLogging!enableSoapAccessLog.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
    </ww:else>
</div>

<%--
Profiling Access Log Section
--%>
<div class="logging-container">
    <a name="profiling"></a>
    <h3 class="formtitle"><ww:text name="'admin.loggingandprofiling.profiling'"/></h3>
    <p><ww:text name="'admin.loggingandprofiling.profiling.description'"/></p>
    <ww:if test="/profilingEnabled == true">
        <p>
        <ww:text name="'admin.loggingandprofiling.profiling.status'">
            <ww:param name="'value0'"><span class="status-active"><ww:text name="'admin.common.words.on'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.disable.profiling'">
                    <ww:param name="'value0'"><a id="disable_profiling" href="ViewLogging!disableProfiling.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
    </ww:if>
    <ww:else>
        <p>
        <ww:text name="'admin.loggingandprofiling.profiling.status'">
            <ww:param name="'value0'"><span class="status-inactive"><ww:text name="'admin.common.words.off'"/></span></ww:param>
        </ww:text>
        </p>
        <ul class="optionslist">
            <li>
                <ww:text name="'admin.loggingandprofiling.enable.profiling'">
                    <ww:param name="'value0'"><a id="enable_profiling" href="ViewLogging!enableProfiling.jspa"><b></ww:param>
                    <ww:param name="'value1'"></b></a></ww:param>
                </ww:text>
            </li>
        </ul>
    </ww:else>
</div>
</body>
</html>

