/**
 * This is to solve the problem of Internet Explorer not being able to prevent blur on mousedown.
 *
 * Usage:
 *
 * $field.preventBlurFromElements(jQuery(".my-dropdown"), jQuery(".some-otherelement"));
 */

jQuery.fn.preventBlurFromElements = function () {

    var elems = jQuery.makeArray(arguments),
        $fromElement = this;

    if (jQuery.browser.msie) {

        $fromElement.bind("beforedeactivate", function (e) {

            var blurEvents;

            // If the toElement is the document, we are scrolling. We still want the user to be able to scroll so
            // we cannot prevent default so have to use a work around to allow the blur to take place with no effect.
            if (e.toElement === document.documentElement) {

                blurEvents = $fromElement.data("events").blur;  // store reference to all blur events

                delete $fromElement.data("events").blur; // remove all blur events now

                $fromElement.one("blur", function () {

                    $fromElement.focus();

                    // need to use timeout otherwise all event handlers will still be fired, as they are referenced in the
                    // same array as the one we just added.
                    window.setTimeout(function (    ) {
                        $fromElement.data("events").blur = blurEvents;
                    }, 0);
                });

            } else {

                // If the element to be focused is one of the elements we want to prevent the blur from we are going
                // to prevent default. This has the effect of preventing the bluring.
                jQuery.each(elems, function () {
                    var $elem = jQuery(this);
                    if ($elem.has(e.toElement).length === 1) {
                        e.preventDefault();
                        return false;
                    }
                });
            }
        });

    } else {

        // for all other browsers we can just preventDefault on the mousedown event.


        jQuery.each(elems, function () {
            this.mousedown(function (e) {
                if (e.target !== $fromElement[0]) {
                    e.preventDefault();
                }
            })
        });
    }
};