/**
 * @method jQuery.fn.isDirty
 * @return {boolean} -- indicates whether a form in the given collection is dirty
 *
 * Applies to all forms that are either: (a) in the current jQuery collection, or
 *                                       (b) descendants of elements in the current collection
 */
AJS.$.fn.isDirty = function() {
    var isClean = true;

    this.find("form").add(this.filter("form")).not(AJS.DIRTY_FORM_EXEMPT).each(function() {
        var initValue = AJS.$.data(this, AJS.DIRTY_FORM_VALUE);

        // Break this loop if we find a dirty form -- i.e., when isClean === false.
        return isClean = initValue == null || initValue == AJS.$(this).find(":input").not(AJS.DIRTY_FORM_EXEMPT).serialize();
    });

    return !isClean;
};

/**
 * @method jQuery.fn.removeDirtyWarning
 * @return {jQuery} -- the original jQuery collection, chain away
 *
 * Usage:
 *   AJS.$("#myForm").removeDirtyWarning(); // where AJS.$("#myForm") is a jQuery collection of form elements
 *
 * This declares the form's current state as clean, and no warnings will appear unless the form data is changed.
 */
AJS.$.fn.removeDirtyWarning = function() {
    return this.each(function() {
        AJS.$.data(this, AJS.DIRTY_FORM_VALUE, null);
    });
};

(function() {
    var $doc = AJS.$(document);
    var excluded = $doc;
    var oldOnbeforeunload = window.onbeforeunload;

    window.onbeforeunload = function() {
        if (oldOnbeforeunload) {
            oldOnbeforeunload();
        }
        if (AJS.$("form").not(excluded).isDirty() && !AJS.isSelenium()) {
            return AJS.I18n.getText("common.forms.dirty.message");
        }
    };

    $doc.delegate(":input", "focus", function() {
        // Wait for the DOMContentLoaded handlers to complete, since these may modify forms on the page,
        // then capture form states.
        var theForm = this.form;
        setTimeout(function() {
            initForm.call(theForm);
        }, 50);
    });

    AJS.$(function() {
        // Wait for the DOMContentLoaded handlers to complete, since these may modify forms on the page,
        // then capture form states.
        setTimeout(function() {
            AJS.$("form").each(initForm);
        }, 50);

        $doc.delegate("*", "submit fakesubmit", muteWarnings);

        // Bind manually to appease IE.
        AJS.$("form").bind("submit", muteWarnings);
    });

    function initForm() {
        // Ignore forms that already have a clean value stored.
        if (AJS.$.data(this, AJS.DIRTY_FORM_VALUE)) {
            return;
        }
        // Some forms are exempt from dirtiness warnings. Skip these:
        // * #jqlform                       JQL autocomplete on issue_nav
        // * #quicksearch                   Quicksearch input in header
        // * #issue-create-quick            Quick create issue inline popup
        // * #issue-actions-dialog-form     the dot dialog
        // * .userpref-form                 Hidden form on the dashboard that is set when saving user prefs
        if (AJS.$(this).is("#jqlform, #quicksearch, #issue-create-quick, #issue-actions-dialog-form, .userpref-form")) {
            return;
        }
        // Store a snapshot of this form's initial state (it's "clean value"), in order to compare against this later.
        AJS.$.data(this, AJS.DIRTY_FORM_VALUE, AJS.$(this).find(":input[name!=atl_token]").serialize());
    }

    // Need mousedown, keydown and click events here because there's lots of different ways to trigger these events and not all work the same in all
    // browsers.
    //
    // Ignoring warnings for the following:
    // * a.cancel,#cancelButton             Cancel link on forms & dialogs
    // * #refresh-dependant-fields          'Refresh Search' link on simple search form on issue_nav
    // * form#tabForm table#field_table a   Up/Down links for individual fields on the Configure Screen form in the Admin section
    $doc.delegate("a.cancel,#cancelButton,#refresh-dependant-fields,form#tabForm table#field_table a", "mousedown keydown click", muteWarnings);

    function muteWarnings() {
        // Submitting or cancelling a form should only trigger a warning if a *different* form is dirty.
        excluded = this.form || AJS.$(this).closest("form")[0] || excluded;

        // If this action doesn't trigger a page load, restore the original onbeforeunload handler.
        if (this.id === "cancelButton") {
            AJS.$(this).one("click", restoreWarnings);
        } else {
            restoreWarnings();
        }
    }

    function restoreWarnings() {
        // If the browser is navigating to a new page, this timeout should be automatically cleared,
        // so the warning won't be shown.
        // NOTE: The timeout needs to be reasonably large, otherwise it can happen that the exclusion
        // is cleared before the onbeforeunload handler has a chance to run!
        setTimeout(function() {
            excluded = $doc;
        }, 500);
    }
})();
