<%@ page import="com.atlassian.jira.ComponentManager" %>
<%@ page import="com.atlassian.jira.security.JiraAuthenticationContext" %>
<%@ page import="webwork.action.ActionContext" %>
<%@ taglib uri="webwork" prefix="ww" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="jiratags" prefix="jira" %>

<%
    // Plugins 2.5 allows us to perform context-based resource inclusion. This defines the context "atl.userprofile"
    final WebResourceManager wrm = ComponentManager.getInstance().getWebResourceManager();
    wrm.requireResourcesForContext("atl.userprofile");
    wrm.requireResourcesForContext("jira.userprofile");

%>
<%@ include file="/includes/decorators/header-deprecated.jsp" %>
<%
    JiraAuthenticationContext authenticationContext = ComponentManager.getInstance().getJiraAuthenticationContext();
    final HttpServletRequest originalRequest = ActionContext.getRequest();
    try
    {
        //full user format requires the request to be set in the ActionContext :(
        ActionContext.setRequest(request);
        if(authenticationContext.getUser() != null)
        {
            request.setAttribute("username", authenticationContext.getUser().getName());
        }
%>
<body class="nl">
<div id="admin-config">
    <div class="admin-active-area">
        <div class="user-details-container">
            <jira:formatuser user="@username" type="'fullProfile'" id="'view_profile'"/>
        </div>
        <decorator:body />
    </div>
</div>
<%
    }
    finally
    {
        ActionContext.setRequest(originalRequest);
    }
%>
<%@ include file="/includes/decorators/footer.jsp" %>
