/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.XADataSource;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.transaction.TransactionIsolations;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilValidate;

public class JotmConnectionFactory {
    public static final String module = JotmConnectionFactory.class.getName();
    protected static Map<String, StandardXAPoolDataSource> dsCache = CopyOnWriteMap.newHashMap();

    public static synchronized void removeDatasource(String helperName) {
        StandardXAPoolDataSource pds = dsCache.get(helperName);
        if (pds != null) {
            pds.shutdown(true);
            dsCache.remove(helperName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        StandardXAPoolDataSource pds = dsCache.get(helperName);
        if (pds != null) {
            if (Debug.verboseOn()) {
                Debug.logInfo((String)(helperName + " pool size: " + pds.pool.getCount()), (String)module);
            }
            return pds.getConnection();
        }
        Class<JotmConnectionFactory> clazz = JotmConnectionFactory.class;
        synchronized (JotmConnectionFactory.class) {
            StandardXADataSource ds;
            pds = dsCache.get(helperName);
            if (pds != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return pds.getConnection();
            }
            try {
                ds = new StandardXADataSource();
                pds = new StandardXAPoolDataSource();
            }
            catch (NoClassDefFoundError e) {
                throw new GenericEntityException("Cannot find enhydra-jdbc.jar");
            }
            ds.setDriverName(jdbcDatasource.getDriverClassName());
            ds.setUrl(jdbcDatasource.getUri());
            ds.setUser(jdbcDatasource.getUsername());
            ds.setPassword(jdbcDatasource.getPassword());
            ds.setDescription(helperName);
            ds.setTransactionManager(TransactionFactory.getTransactionManager());
            String transIso = jdbcDatasource.getIsolationLevel();
            if (UtilValidate.isNotEmpty((String)transIso)) {
                ds.setTransactionIsolation(TransactionIsolations.fromString(transIso));
            }
            pds.setDataSource((XADataSource)ds);
            pds.setDescription(ds.getDescription());
            pds.setUser(ds.getUser());
            pds.setPassword(ds.getPassword());
            pds.setTransactionManager(TransactionFactory.getTransactionManager());
            ConnectionPoolInfo poolInfo = jdbcDatasource.getConnectionPoolInfo();
            try {
                pds.setMaxSize(poolInfo.getMaxSize());
                pds.setMinSize(poolInfo.getMinSize());
                pds.setSleepTime(poolInfo.getSleepTime());
                pds.setLifeTime(poolInfo.getLifeTime());
                pds.setDeadLockMaxWait(poolInfo.getDeadLockMaxWait());
                pds.setDeadLockRetryWait(poolInfo.getDeadLockRetryWait());
                pds.setJdbcTestStmt(poolInfo.getValidationQuery());
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)("Problems with pool settings: " + poolInfo), (String)module);
            }
            dsCache.put(helperName, pds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return pds.getConnection();
        }
    }
}

