/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.transaction.TransactionIsolations;
import org.ofbiz.core.entity.util.PropertyUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilValidate;

public class DBCPConnectionFactory {
    protected static Map<String, DataSource> dsCache = CopyOnWriteMap.newHashMap();
    protected static Map<String, ObjectPool> connectionPoolCache = CopyOnWriteMap.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        DataSource dataSource = dsCache.get(helperName);
        if (dataSource != null) {
            return dataSource.getConnection();
        }
        try {
            Class<DBCPConnectionFactory> clazz = DBCPConnectionFactory.class;
            synchronized (DBCPConnectionFactory.class) {
                ConnectionPoolInfo poolInfo;
                Properties info;
                dataSource = dsCache.get(helperName);
                if (dataSource != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return dataSource.getConnection();
                }
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                connectionPoolCache.put(helperName, (ObjectPool)connectionPool);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                loader.loadClass(jdbcDatasource.getDriverClassName());
                Properties properties = info = jdbcDatasource.getConnectionProperties() != null ? PropertyUtils.copyOf(jdbcDatasource.getConnectionProperties()) : new Properties();
                if (jdbcDatasource.getUsername() != null) {
                    info.setProperty("user", jdbcDatasource.getUsername());
                }
                if (jdbcDatasource.getPassword() != null) {
                    info.setProperty("password", jdbcDatasource.getPassword());
                }
                DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcDatasource.getUri(), info);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
                if (UtilValidate.isNotEmpty((String)jdbcDatasource.getIsolationLevel())) {
                    poolableConnectionFactory.setDefaultTransactionIsolation(TransactionIsolations.fromString(jdbcDatasource.getIsolationLevel()));
                }
                if ((poolInfo = jdbcDatasource.getConnectionPoolInfo()) != null) {
                    connectionPool.setMaxActive(poolInfo.getMaxSize());
                    if (UtilValidate.isNotEmpty((String)poolInfo.getValidationQuery())) {
                        connectionPool.setTestOnBorrow(true);
                        poolableConnectionFactory.setValidationQuery(poolInfo.getValidationQuery());
                    }
                    if (poolInfo.getMinEvictableTimeMillis() != null) {
                        connectionPool.setMinEvictableIdleTimeMillis(poolInfo.getMinEvictableTimeMillis().longValue());
                    }
                    if (poolInfo.getTimeBetweenEvictionRunsMillis() != null) {
                        connectionPool.setTimeBetweenEvictionRunsMillis(poolInfo.getTimeBetweenEvictionRunsMillis().longValue());
                    }
                }
                dataSource = new PoolingDataSource((ObjectPool)connectionPool);
                dataSource.setLogWriter(Debug.getPrintWriter());
                dsCache.put(helperName, dataSource);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return dataSource.getConnection();
            }
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)("Error getting datasource via DBCP: " + jdbcDatasource));
            return null;
        }
    }

    public static synchronized void removeDatasource(String helperName) {
        DataSource dataSource = dsCache.get(helperName);
        if (dataSource != null) {
            ObjectPool connectionPool = connectionPoolCache.get(helperName);
            if (connectionPool != null) {
                try {
                    connectionPool.close();
                }
                catch (Exception e) {
                    Debug.logError((Throwable)e, (String)"Error closing connection pool in DBCP");
                }
                connectionPoolCache.remove(helperName);
            }
            dsCache.remove(helperName);
        }
    }
}

