/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.jdbc.dbtype.DB2DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.Oracle10GDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.Oracle8IDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.Postgres72DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.Postgres73DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.PostgresDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.SapDB76DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.SapDBDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.SimpleDatabaseType;
import org.ofbiz.core.util.Debug;

public class DatabaseTypeFactory {
    static final Collection<DatabaseType> DATABASE_TYPES = new ArrayList<DatabaseType>();
    public static final DatabaseType DB2 = new DB2DatabaseType();
    public static final DatabaseType CLOUDSCAPE = new SimpleDatabaseType("Cloudscape", "cloudscape", new String[]{"Apache Derby"});
    public static final DatabaseType FIREBIRD = new SimpleDatabaseType("Firebird", "firebird", new String[]{"Firebird"});
    public static final DatabaseType HSQL = new SimpleDatabaseType("HSQL", "hsql", new String[]{"HSQL Database Engine"});
    public static final DatabaseType H2 = new SimpleDatabaseType("H2", "h2", new String[]{"H2"});
    public static final DatabaseType MYSQL = new SimpleDatabaseType("MySQL", "mysql", new String[]{"MySQL"});
    public static final DatabaseType MSSQL = new SimpleDatabaseType("MS SQL", "mssql", new String[]{"Microsoft SQL Server"});
    public static final DatabaseType ORACLE_10G = new Oracle10GDatabaseType();
    public static final DatabaseType ORACLE_8I = new Oracle8IDatabaseType();
    public static final DatabaseType POSTGRES_7_2 = new Postgres72DatabaseType();
    public static final DatabaseType POSTGRES_7_3 = new Postgres73DatabaseType();
    public static final DatabaseType POSTGRES = new PostgresDatabaseType();
    public static final DatabaseType SAP_DB = new SapDBDatabaseType();
    public static final DatabaseType SAP_DB_7_6 = new SapDB76DatabaseType();
    public static final DatabaseType SYBASE = new SimpleDatabaseType("Sybase", "sybase", new String[]{"Adaptive Server", "sql server"});

    public static void registerDatabaseType(DatabaseType databaseType) {
        DATABASE_TYPES.add(databaseType);
    }

    public static DatabaseType getTypeForConnection(Connection con) {
        for (DatabaseType databaseType : DATABASE_TYPES) {
            try {
                if (!databaseType.matchesConnection(con)) continue;
                Debug.logInfo((String)("Returning DatabaseType " + databaseType));
                return databaseType;
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)"Exception occured while trying to match the database connection to a DatabaseType");
            }
        }
        DatabaseTypeFactory.logDatabaseNotMatchedError(con);
        return null;
    }

    private static void logDatabaseNotMatchedError(Connection con) {
        try {
            DatabaseMetaData md = con.getMetaData();
            Debug.logError((String)("Could not determine database type.  Database meta-data: " + md.getDatabaseProductName() + " " + md.getDatabaseProductVersion() + ".  Driver meta-data: " + md.getDriverName() + " " + md.getDriverVersion() + "."));
            Debug.logError((String)("Please specify field type name in entityengine.xml.  Replace " + DatasourceInfo.AUTO_FIELD_TYPE + " with specific field type name."));
        }
        catch (SQLException e) {
            Debug.logError((Throwable)e, (String)"Could not determine database type. SQLException occured when trying to retrieve connection meta-data");
        }
    }
}

