/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.Debug;

public class SequenceUtil {
    public static final String module = SequenceUtil.class.getName();
    Map<String, SequenceBank> sequences = new Hashtable<String, SequenceBank>();
    String helperName;
    ModelEntity seqEntity;
    String tableName;
    String nameColName;
    String idColName;

    private SequenceUtil() {
    }

    public SequenceUtil(String helperName, ModelEntity seqEntity, String nameFieldName, String idFieldName) {
        this.helperName = helperName;
        this.seqEntity = seqEntity;
        if (seqEntity == null) {
            throw new IllegalArgumentException("The sequence model entity was null but is required.");
        }
        this.tableName = seqEntity.getTableName(helperName);
        ModelField nameField = seqEntity.getField(nameFieldName);
        if (nameField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence name field " + nameFieldName);
        }
        this.nameColName = nameField.getColName();
        ModelField idField = seqEntity.getField(idFieldName);
        if (idField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence id field " + idFieldName);
        }
        this.idColName = idField.getColName();
    }

    public Long getNextSeqId(String seqName) {
        SequenceBank bank = this.sequences.get(seqName);
        if (bank == null) {
            bank = this.constructSequenceBank(seqName);
        }
        return bank.getNextSeqId();
    }

    private synchronized SequenceBank constructSequenceBank(String seqName) {
        SequenceBank bank = this.sequences.get(seqName);
        if (bank == null) {
            bank = new SequenceBank(seqName, this);
            this.sequences.put(seqName, bank);
        }
        return bank;
    }

    class SequenceBank {
        public static final long bankSize = 100L;
        public static final long startSeqId = 10000L;
        public static final int minWaitNanos = 500000;
        public static final int maxWaitNanos = 1000000;
        public static final int maxTries = 5;
        long curSeqId;
        long maxSeqId;
        String seqName;
        SequenceUtil parentUtil;

        public SequenceBank(String seqName, SequenceUtil parentUtil) {
            this.seqName = seqName;
            this.parentUtil = parentUtil;
            this.curSeqId = 0L;
            this.maxSeqId = 0L;
            this.fillBank();
        }

        public synchronized Long getNextSeqId() {
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = this.curSeqId;
                ++this.curSeqId;
                return retSeqId;
            }
            this.fillBank();
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = this.curSeqId;
                ++this.curSeqId;
                return retSeqId;
            }
            Debug.logError((String)"[SequenceUtil.SequenceBank.getNextSeqId] Fill bank failed, returning null", (String)module);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected synchronized void fillBank() {
            TransactionManager transactionManager;
            Transaction suspendedTransaction;
            boolean manualTX;
            long val2;
            long val1;
            block78: {
                if (this.curSeqId < this.maxSeqId) {
                    return;
                }
                val1 = 0L;
                val2 = 0L;
                manualTX = true;
                suspendedTransaction = null;
                transactionManager = null;
                try {
                    if (TransactionUtil.getStatus() != 0) break block78;
                    manualTX = false;
                    try {
                        transactionManager = TransactionFactory.getTransactionManager();
                        if (transactionManager != null) {
                            suspendedTransaction = transactionManager.suspend();
                            manualTX = true;
                        }
                    }
                    catch (SystemException e) {
                        Debug.logError((Throwable)e, (String)"System Error suspending transaction in sequence util");
                    }
                }
                catch (GenericTransactionException e) {
                    Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] Exception was thrown trying to check transaction status: " + e.toString()), (String)module);
                }
            }
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                connection = ConnectionFactory.getConnection(this.parentUtil.helperName);
            }
            catch (SQLException sqle) {
                Debug.logWarning((String)"[SequenceUtil.SequenceBank.fillBank]: Unable to esablish a connection with the database... Error was:", (String)module);
                Debug.logWarning((String)sqle.getMessage(), (String)module);
            }
            catch (GenericEntityException e) {
                Debug.logWarning((String)"[SequenceUtil.SequenceBank.fillBank]: Unable to esablish a connection with the database... Error was:", (String)module);
                Debug.logWarning((String)e.getMessage(), (String)module);
            }
            String sql = null;
            try {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException sqle) {
                    manualTX = false;
                }
                stmt = connection.createStatement();
                int numTries = 0;
                while (val1 + 100L != val2) {
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Trying to get a bank of sequenced ids for " + this.seqName + "; start of loop val1=" + val1 + ", val2=" + val2 + ", bankSize=" + 100L), (String)module);
                    }
                    if (!(rs = stmt.executeQuery(sql = "SELECT " + this.parentUtil.idColName + " FROM " + this.parentUtil.tableName + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'")).next()) {
                        Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] first select failed: trying to add row, result set was empty for sequence: " + this.seqName), (String)module);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sqle) {
                            Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                        }
                        if (stmt.executeUpdate(sql = "INSERT INTO " + this.parentUtil.tableName + " (" + this.parentUtil.nameColName + ", " + this.parentUtil.idColName + ") VALUES ('" + this.seqName + "', " + 10000L + ")") > 0) continue;
                        return;
                    }
                    val1 = rs.getInt(this.parentUtil.idColName);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                    }
                    sql = "UPDATE " + this.parentUtil.tableName + " SET " + this.parentUtil.idColName + "=" + this.parentUtil.idColName + "+" + 100L + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'";
                    if (stmt.executeUpdate(sql) <= 0) {
                        Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] update failed, no rows changes for seqName: " + this.seqName), (String)module);
                        return;
                    }
                    if (manualTX) {
                        connection.commit();
                    }
                    if (!(rs = stmt.executeQuery(sql = "SELECT " + this.parentUtil.idColName + " FROM " + this.parentUtil.tableName + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'")).next()) {
                        Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] second select failed: aborting, result set was empty for sequence: " + this.seqName), (String)module);
                        try {
                            if (rs == null) return;
                            rs.close();
                            return;
                        }
                        catch (SQLException sqle) {
                            Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                        }
                        return;
                    }
                    val2 = rs.getInt(this.parentUtil.idColName);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                    }
                    if (manualTX) {
                        connection.commit();
                    }
                    if (val1 + 100L != val2) {
                        if (numTries >= 5) {
                            Debug.logError((String)"[SequenceUtil.SequenceBank.fillBank] maxTries (5) reached, giving up.", (String)module);
                            return;
                        }
                        int waitTime = new Double(Math.random() * 500000.0).intValue() + 500000;
                        try {
                            this.wait(0L, waitTime);
                        }
                        catch (Exception e) {
                            Debug.logWarning((Throwable)e, (String)"Error waiting in sequence util");
                        }
                    }
                    ++numTries;
                }
                this.curSeqId = val1;
                this.maxSeqId = val2;
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Successfully got a bank of sequenced ids for " + this.seqName + "; curSeqId=" + this.curSeqId + ", maxSeqId=" + this.maxSeqId + ", bankSize=" + 100L), (String)module);
                }
            }
            catch (SQLException sqle) {
                Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] SQL Exception while executing the following:\n" + sql + "\nError was:"), (String)module);
                Debug.logWarning((String)sqle.getMessage(), (String)module);
                return;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle) {
                    Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle) {
                    Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                }
            }
            if (suspendedTransaction == null) return;
            try {
                if (transactionManager == null) {
                    transactionManager = TransactionFactory.getTransactionManager();
                }
                if (transactionManager == null) return;
                transactionManager.resume(suspendedTransaction);
                return;
            }
            catch (InvalidTransactionException e) {
                Debug.logError((Throwable)e, (String)"InvalidTransaction Error resuming suspended transaction in sequence util");
                return;
            }
            catch (IllegalStateException e) {
                Debug.logError((Throwable)e, (String)"IllegalState Error resuming suspended transaction in sequence util");
                return;
            }
            catch (SystemException e) {
                Debug.logError((Throwable)e, (String)"System Error resuming suspended transaction in sequence util");
            }
        }
    }
}

