/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.hibernate3;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.hibernate3.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate3.HibernatePropertySetDAOUtils;
import com.opensymphony.module.propertyset.hibernate3.PropertySetItem;
import com.opensymphony.module.propertyset.hibernate3.PropertySetItemImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class HibernatePropertySetDAOImpl
implements HibernatePropertySetDAO {
    private SessionFactory sessionFactory;

    public HibernatePropertySetDAOImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setImpl(PropertySetItem item, boolean isUpdate) {
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            if (isUpdate) {
                session.update((Object)item);
            } else {
                session.save((Object)item);
            }
            session.flush();
        }
        catch (HibernateException he) {
            throw new PropertyException("Could not save key '" + item.getKey() + "':" + he.getMessage());
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeys(String entityName, Long entityId, String prefix, int type) {
        Session session = null;
        List list = null;
        try {
            session = this.sessionFactory.openSession();
            list = HibernatePropertySetDAOUtils.getKeysImpl((org.hibernate.Session)session, entityName, entityId, prefix, type);
        }
        catch (HibernateException e) {
            list = Collections.EMPTY_LIST;
        }
        finally {
            try {
                if (session != null) {
                    session.flush();
                    session.close();
                }
            }
            catch (Exception e) {}
        }
        return list;
    }

    public PropertySetItem create(String entityName, long entityId, String key) {
        return new PropertySetItemImpl(entityName, entityId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySetItem findByKey(String entityName, Long entityId, String key) {
        Session session = null;
        PropertySetItem item = null;
        try {
            session = this.sessionFactory.openSession();
            item = HibernatePropertySetDAOUtils.getItem((org.hibernate.Session)session, entityName, entityId, key);
            session.flush();
        }
        catch (HibernateException e) {
            PropertySetItem propertySetItem = null;
            return propertySetItem;
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {}
        }
        return item;
    }

    public void remove(String entityName, Long entityId) {
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            Collection keys = this.getKeys(entityName, entityId, null, 0);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                session.delete((Object)HibernatePropertySetDAOUtils.getItem((org.hibernate.Session)session, entityName, entityId, key));
            }
            session.flush();
        }
        catch (HibernateException e) {
            throw new PropertyException("Could not remove all keys: " + e.getMessage());
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void remove(String entityName, Long entityId, String key) {
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            session.delete((Object)HibernatePropertySetDAOUtils.getItem((org.hibernate.Session)session, entityName, entityId, key));
            session.flush();
        }
        catch (HibernateException e) {
            throw new PropertyException("Could not remove key '" + key + "': " + e.getMessage());
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

