/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public final class Logger {
    private static Writer outLog;
    private static Writer inLog;
    private static final String LOG_PROPERTY = "cvsClientLog";
    private static boolean logging;

    static {
        Logger.setLogging(System.getProperty(LOG_PROPERTY));
    }

    public static void setLogging(String logPath) {
        logging = logPath != null;
        try {
            if (logging) {
                if (logPath.equals("system")) {
                    outLog = new BufferedWriter(new OutputStreamWriter(System.err));
                    inLog = new BufferedWriter(new OutputStreamWriter(System.err));
                } else {
                    outLog = new BufferedWriter(new FileWriter(String.valueOf(logPath) + ".out"));
                    inLog = new BufferedWriter(new FileWriter(String.valueOf(logPath) + ".in"));
                }
            }
        }
        catch (IOException e) {
            System.err.println("Unable to create log files: " + e);
            System.err.println("Logging DISABLED");
            logging = false;
            try {
                if (outLog != null) {
                    outLog.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inLog != null) {
                    inLog.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void logInput(String received) {
        if (!logging) {
            return;
        }
        try {
            inLog.write(received);
            inLog.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logInput(char received) {
        if (!logging) {
            return;
        }
        try {
            inLog.write(received);
            inLog.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logOutput(String sent) {
        if (!logging) {
            return;
        }
        try {
            outLog.write(sent);
            outLog.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }
}

