/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.importcmd;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.response.WrapperSendResponse;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class ImportCommand
extends BuildableCommand {
    private Map wrapperMap = new HashMap();
    private String logMessage;
    private String module;
    private String releaseTag;
    private String vendorBranch;
    private String vendorTag;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;

    public ImportCommand() {
        this.resetCVSCommand();
    }

    public void addWrapper(String filenamePattern, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (keywordSubstitutionOptions == null) {
            throw new IllegalArgumentException("keywordSubstitutionOptions must not be null");
        }
        this.wrapperMap.put(new SimpleStringPattern(filenamePattern), keywordSubstitutionOptions);
    }

    public void addWrapper(StringPattern filenamePattern, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (keywordSubstitutionOptions == null) {
            throw new IllegalArgumentException("keywordSubstitutionOptions must not be null");
        }
        this.wrapperMap.put(filenamePattern, keywordSubstitutionOptions);
    }

    public void setWrappers(Map wrapperMap) {
        this.wrapperMap = wrapperMap;
    }

    public Map getWrappers() {
        return this.wrapperMap;
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public void setReleaseTag(String releaseTag) {
        this.releaseTag = ImportCommand.getTrimmedString(releaseTag);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = ImportCommand.getTrimmedString(logMessage);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = ImportCommand.getTrimmedString(module);
    }

    public String getVendorBranch() {
        return this.vendorBranch;
    }

    private String getVendorBranchNotNull() {
        if (this.vendorBranch == null) {
            return "1.1.1";
        }
        return this.vendorBranch;
    }

    public void setVendorBranch(String vendorBranch) {
        this.vendorBranch = ImportCommand.getTrimmedString(vendorBranch);
    }

    public String getVendorTag() {
        return this.vendorTag;
    }

    public void setVendorTag(String vendorTag) {
        this.vendorTag = ImportCommand.getTrimmedString(vendorTag);
    }

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        if (this.getLogMessage() == null) {
            String localizedMsg = CommandException.getLocalMessage("ImportCommand.messageEmpty");
            throw new CommandException("message may not be null nor empty", localizedMsg);
        }
        if (this.getModule() == null) {
            String localizedMsg = CommandException.getLocalMessage("ImportCommand.moduleEmpty");
            throw new CommandException("module may not be null nor empty", localizedMsg);
        }
        if (this.getReleaseTag() == null) {
            String localizedMsg = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty");
            throw new CommandException("release tag may not be null nor empty", localizedMsg);
        }
        if (this.getVendorTag() == null) {
            String localizedMsg = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty");
            throw new CommandException("vendor tag may not be null nor empty", localizedMsg);
        }
        client.ensureConnection();
        HashMap allWrappersMap = new HashMap(client.getWrappersMap());
        allWrappersMap.putAll(this.getWrappers());
        this.setWrappers(allWrappersMap);
        super.execute(client, eventManager);
        ArrayList<Request> requestList = new ArrayList<Request>();
        try {
            requestList.add(new ArgumentRequest("-b"));
            requestList.add(new ArgumentRequest(this.getVendorBranchNotNull()));
            if (this.getKeywordSubstitutionOptions() != null) {
                requestList.add(new ArgumentRequest("-k"));
                requestList.add(new ArgumentRequest(this.getKeywordSubstitutionOptions().toString()));
            }
            this.addMessageRequests(requestList, this.getLogMessage());
            this.addWrapperRequests(requestList, this.wrapperMap);
            requestList.add(new ArgumentRequest(this.getModule()));
            requestList.add(new ArgumentRequest(this.getVendorTag()));
            requestList.add(new ArgumentRequest(this.getReleaseTag()));
            this.addFileRequests(new File(this.getLocalDirectory()), requestList, client);
            requestList.add(new DirectoryRequest(".", this.getRepositoryRoot(client)));
            requestList.add(CommandRequest.IMPORT);
            client.processRequests(requestList);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (EOFException ex) {
            String localizedMsg = CommandException.getLocalMessage("CommandException.EndOfFile", null);
            throw new CommandException(ex, localizedMsg);
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    public String getCVSCommand() {
        String localizedMsg;
        StringBuffer toReturn = new StringBuffer("import ");
        toReturn.append(this.getCVSArguments());
        if (this.getModule() != null) {
            toReturn.append(" ");
            toReturn.append(this.getModule());
        } else {
            localizedMsg = CommandException.getLocalMessage("ImportCommand.moduleEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        if (this.getVendorTag() != null) {
            toReturn.append(" ");
            toReturn.append(this.getVendorTag());
        } else {
            localizedMsg = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        if (this.getReleaseTag() != null) {
            toReturn.append(" ");
            toReturn.append(this.getReleaseTag());
        } else {
            localizedMsg = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        return toReturn.toString();
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.getLogMessage() != null) {
            toReturn.append("-m \"");
            toReturn.append(this.getLogMessage());
            toReturn.append("\" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubstitutionOptions().toString());
            toReturn.append(" ");
        }
        if (this.getVendorBranch() != null) {
            toReturn.append("-b ");
            toReturn.append(this.getVendorBranch());
            toReturn.append(" ");
        }
        if (this.wrapperMap.size() > 0) {
            Iterator it = this.wrapperMap.keySet().iterator();
            while (it.hasNext()) {
                StringPattern pattern = (StringPattern)it.next();
                KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(pattern);
                toReturn.append("-W ");
                toReturn.append(pattern.toString());
                toReturn.append(" -k '");
                toReturn.append(keywordSubstitutionOptions.toString());
                toReturn.append("' ");
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'b') {
            this.setVendorBranch(optArg);
        } else if (opt == 'm') {
            this.setLogMessage(optArg);
        } else if (opt == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(optArg));
        } else if (opt == 'W') {
            Map wrappers = WrapperSendResponse.parseWrappers(optArg);
            Iterator it = wrappers.keySet().iterator();
            while (it.hasNext()) {
                StringPattern pattern = (StringPattern)it.next();
                KeywordSubstitutionOptions keywordOption = (KeywordSubstitutionOptions)wrappers.get(pattern);
                this.addWrapper(pattern, keywordOption);
            }
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setLogMessage(null);
        this.setModule(null);
        this.setReleaseTag(null);
        this.setVendorTag(null);
        this.setVendorBranch(null);
        this.wrapperMap.clear();
    }

    public String getOptString() {
        return "m:W:b:k:";
    }

    private void addMessageRequests(List requestList, String logMessage) {
        requestList.add(new ArgumentRequest("-m"));
        StringTokenizer token = new StringTokenizer(logMessage, "\n", false);
        boolean first = true;
        while (token.hasMoreTokens()) {
            if (first) {
                requestList.add(new ArgumentRequest(token.nextToken()));
                first = false;
                continue;
            }
            requestList.add(new ArgumentxRequest(token.nextToken()));
        }
    }

    private void addWrapperRequests(List requestList, Map wrapperMap) {
        Iterator it = wrapperMap.keySet().iterator();
        while (it.hasNext()) {
            StringPattern pattern = (StringPattern)it.next();
            KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)wrapperMap.get(pattern);
            StringBuffer buffer = new StringBuffer();
            buffer.append(pattern.toString());
            buffer.append(" -k '");
            buffer.append(keywordSubstitutionOptions.toString());
            buffer.append("'");
            requestList.add(new ArgumentRequest("-W"));
            requestList.add(new ArgumentRequest(buffer.toString()));
        }
    }

    private void addFileRequests(File directory, List requestList, ClientServices clientServices) throws IOException {
        String relativePath = this.getRelativeToLocalPathInUnixStyle(directory);
        String repository = this.getRepositoryRoot(clientServices);
        if (!relativePath.equals(".")) {
            repository = String.valueOf(repository) + '/' + relativePath;
        }
        requestList.add(new DirectoryRequest(relativePath, repository));
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        LinkedList<File> subdirectories = null;
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String filename = file.getName();
            if (!clientServices.shouldBeIgnored(directory, filename)) {
                if (file.isDirectory()) {
                    if (subdirectories == null) {
                        subdirectories = new LinkedList<File>();
                    }
                    subdirectories.add(file);
                } else {
                    boolean isBinary = this.isBinary(filename);
                    requestList.add(new ModifiedRequest(file, isBinary));
                }
            }
            ++i;
        }
        if (subdirectories != null) {
            Iterator it = subdirectories.iterator();
            while (it.hasNext()) {
                File subdirectory = (File)it.next();
                this.addFileRequests(subdirectory, requestList, clientServices);
            }
        }
    }

    private String getRepositoryRoot(ClientServices clientServices) {
        String repository = String.valueOf(clientServices.getRepository()) + '/' + this.getModule();
        return repository;
    }

    private boolean isBinary(String filename) {
        KeywordSubstitutionOptions keywordSubstitutionOptions = this.getKeywordSubstitutionOptions();
        Iterator it = this.wrapperMap.keySet().iterator();
        while (it.hasNext()) {
            StringPattern pattern = (StringPattern)it.next();
            if (!pattern.doesMatch(filename)) continue;
            keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(pattern);
            break;
        }
        return keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY;
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ImportBuilder(eventManager, this);
    }
}

