/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.renderer.FileCollectionFormatter;
import net.sf.statcvs.util.OutputUtils;

public class CommitLogRenderer {
    private static final int PAGE_SIZE = 50;
    private List commits;
    private int currentPage;
    private List pageCommits;
    private HashMap commitHashMap = new HashMap();
    private WebRepositoryIntegration webRepository;

    public CommitLogRenderer(List commits) {
        this.commits = new ArrayList(commits);
        Collections.reverse(this.commits);
        this.webRepository = ConfigurationOptions.getWebRepository();
    }

    public String renderMostRecentCommits(int maxCommits) {
        if (this.commits.size() > maxCommits) {
            List recentCommits = this.commits.subList(0, maxCommits);
            return this.renderCommitList(recentCommits) + "<p>(" + (this.commits.size() - maxCommits) + " " + Messages.getString("MORE_COMMITS") + ")</p>\n";
        }
        return this.renderCommitList(this.commits);
    }

    public String renderPage(int page) {
        this.currentPage = page;
        this.pageCommits = this.commits.subList(this.getFirstCommitOfPage(page), this.getLastCommitOfPage(page) + 1);
        String result = "";
        if (this.getPages() > 1) {
            result = result + this.renderNavigation();
        }
        result = result + this.renderTimespan();
        result = result + this.renderCommitList(this.pageCommits);
        if (this.getPages() > 1) {
            result = result + this.renderNavigation();
        }
        return result;
    }

    private String renderTimespan() {
        Date time1 = ((Commit)this.pageCommits.get(0)).getDate();
        Date time2 = ((Commit)this.pageCommits.get(this.pageCommits.size() - 1)).getDate();
        String commitsText = this.getPages() > 1 ? Messages.getString("COMMITS") + " " + (this.commits.size() - this.getLastCommitOfPage(this.currentPage)) + "-" + (this.commits.size() - this.getFirstCommitOfPage(this.currentPage)) + " of " + this.commits.size() : this.commits.size() + " " + Messages.getString("COMMITS");
        return HTMLTagger.getSummaryPeriod(time1, time2, " (" + commitsText + ")");
    }

    private String renderNavigation() {
        String result = Messages.getString("PAGES") + ": ";
        if (this.currentPage > 1) {
            result = result + HTMLTagger.getLink(CommitLogRenderer.getFilename(this.currentPage - 1), Messages.getString("NAVIGATION_PREVIOUS")) + " ";
        }
        for (int i = 1; i <= this.getPages(); ++i) {
            result = i == this.currentPage ? result + i + " " : result + HTMLTagger.getLink(CommitLogRenderer.getFilename(i), Integer.toString(i)) + " ";
        }
        if (this.currentPage < this.getPages()) {
            result = result + HTMLTagger.getLink(CommitLogRenderer.getFilename(this.currentPage + 1), Messages.getString("NAVIGATION_NEXT")) + " ";
        }
        return "<p>" + result + "</p>\n";
    }

    private int getFirstCommitOfPage(int page) {
        return (page - 1) * 50;
    }

    private int getLastCommitOfPage(int page) {
        return Math.min(this.commits.size(), page * 50) - 1;
    }

    public int getPages() {
        return (this.commits.size() + 50 - 1) / 50;
    }

    public static String getFilename(int page) {
        if (page == 1) {
            return "commit_log.html";
        }
        return "commit_log_page_" + page + ".html";
    }

    private String renderCommitList(List commitList) {
        if (commitList.isEmpty()) {
            return "<p>No commits</p>\n";
        }
        Iterator it = commitList.iterator();
        String result = "<dl class=\"commitlist\">\n";
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            result = result + this.renderCommit(commit);
        }
        result = result + "</dl>\n\n";
        return result;
    }

    private String renderCommit(Commit commit) {
        String result = "  <dt>\n    " + this.getAuthor(commit) + "\n";
        result = result + "    " + this.getDate(commit) + "\n  </dt>\n";
        result = result + "  <dd>\n    <p class=\"comment\">\n" + this.getComment(commit) + "\n    </p>\n";
        result = result + "    <p class=\"commitdetails\"><strong>";
        result = result + this.getLinesOfCode(commit) + "</strong> ";
        result = result + "lines of code changed in:</p>\n";
        result = result + this.getAffectedFiles(commit) + "  </dd>\n\n";
        return result;
    }

    private String getDate(Commit commit) {
        return HTMLTagger.getDateAndTime(commit.getDate());
    }

    private String getAuthor(Commit commit) {
        return HTMLTagger.getAuthorLink(commit.getAuthor());
    }

    private String getComment(Commit commit) {
        return OutputUtils.escapeHtml(commit.getComment());
    }

    private String getLinesOfCode(Commit commit) {
        Iterator it = commit.getRevisions().iterator();
        int locSum = 0;
        while (it.hasNext()) {
            CvsRevision each = (CvsRevision)it.next();
            locSum += each.getNewLines();
            this.saveCvsRevision(each);
        }
        return Integer.toString(locSum);
    }

    private void saveCvsRevision(CvsRevision revision) {
        this.commitHashMap.put(revision.getFile().getFilenameWithPath(), revision);
    }

    private String getAffectedFiles(Commit commit) {
        String result = "    <ul class=\"commitdetails\">\n";
        FileCollectionFormatter formatter = new FileCollectionFormatter(commit.getAffectedFiles());
        Iterator it = formatter.getDirectories().iterator();
        while (it.hasNext()) {
            result = result + "      <li>\n";
            String directory = (String)it.next();
            if (!directory.equals("")) {
                result = result + "        <strong>" + directory.substring(0, directory.length() - 1) + "</strong>:\n";
            }
            Iterator files = formatter.getFiles(directory).iterator();
            String fileList = "";
            while (files.hasNext()) {
                if (!fileList.equals("")) {
                    fileList = fileList + ",\n";
                }
                fileList = fileList + "        ";
                String file = (String)files.next();
                CvsRevision revision = (CvsRevision)this.commitHashMap.get(directory + file);
                if (this.webRepository != null) {
                    CvsRevision previous = revision.getPreviousRevision();
                    String url = previous == null || revision.isInitialRevision() ? this.webRepository.getFileViewUrl(revision) : (revision.isDead() ? this.webRepository.getFileViewUrl(previous) : this.webRepository.getDiffUrl(previous, revision));
                    fileList = fileList + "<a href=\"" + OutputUtils.escapeHtml(url) + "\" class=\"webrepository\">" + file + "</a>";
                } else {
                    fileList = fileList + file;
                }
                if (revision.isInitialRevision()) {
                    int linesAdded = revision.getLines();
                    fileList = fileList + "&nbsp;<span class=\"new\">(new";
                    if (linesAdded > 0) {
                        fileList = fileList + "&nbsp;" + linesAdded;
                    }
                    fileList = fileList + ")</span>";
                    continue;
                }
                if (revision.isDead()) {
                    fileList = fileList + "&nbsp;<span class=\"del\">(del)</span>";
                    continue;
                }
                int delta = revision.getLinesDelta();
                int linesAdded = revision.getReplacedLines() + (delta > 0 ? delta : 0);
                int linesRemoved = revision.getReplacedLines() - (delta < 0 ? delta : 0);
                fileList = fileList + "&nbsp;<span class=\"change\">(";
                if (linesAdded > 0) {
                    fileList = fileList + "+" + linesAdded;
                    if (linesRemoved > 0) {
                        fileList = fileList + "&nbsp;-" + linesRemoved;
                    }
                } else {
                    fileList = linesRemoved > 0 ? fileList + "-" + linesRemoved : fileList + "changed";
                }
                fileList = fileList + ")</span>";
            }
            result = result + fileList + "\n      </li>\n";
        }
        result = result + "    </ul>\n";
        return result;
    }
}

