/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.renderer.CommitLogRenderer;

public class CommitLogPage
extends HTMLPage {
    private int pageNr;
    private CommitLogRenderer logRenderer;

    public CommitLogPage(CvsContent content, CommitLogRenderer logRenderer, int pageNr, int totalPages) throws IOException {
        super(content);
        this.logRenderer = logRenderer;
        this.setFileName(CommitLogRenderer.getFilename(pageNr));
        this.setPageName(Messages.getString("COMMIT_LOG_TITLE"));
        if (totalPages > 1) {
            this.setPageName(this.getPageName() + " (Page " + pageNr + " of " + totalPages + ")");
        }
        this.pageNr = pageNr;
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        this.print(this.logRenderer.renderPage(this.pageNr));
    }
}

