/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.util;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutStorageException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteFieldValue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.action.issue.UpdateFieldsHelperBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

public class SoapUtilsBean {
    private static final Logger log = Logger.getLogger(SoapUtilsBean.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldManager fieldManager;
    private final UpdateFieldsHelperBean updateFieldsHelperBean;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueCreationHelperBean creationHelperBean;

    public SoapUtilsBean(FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, UpdateFieldsHelperBean updateFieldsHelperBean, JiraAuthenticationContext authenticationContext, IssueCreationHelperBean creationHelperBean) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldManager = fieldManager;
        this.updateFieldsHelperBean = updateFieldsHelperBean;
        this.authenticationContext = authenticationContext;
        this.creationHelperBean = creationHelperBean;
    }

    public boolean isVisible(GenericValue issue, String fieldname) throws FieldLayoutStorageException {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        return !fieldLayout.getFieldLayoutItem(this.fieldManager.getOrderableField(fieldname)).isHidden();
    }

    public boolean isVisible(Issue issue, String fieldname) throws FieldLayoutStorageException {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue.getProject(), issue.getIssueTypeObject().getId());
        return !fieldLayout.getFieldLayoutItem(this.fieldManager.getOrderableField(fieldname)).isHidden();
    }

    public ExternalComment mapRemoteCommentToExternalComment(RemoteComment remoteComment) {
        try {
            ExternalComment comment = new ExternalComment();
            PropertyUtils.copyProperties((Object)comment, (Object)remoteComment);
            return comment;
        }
        catch (Exception e) {
            log.warn((Object)"Could not convert issue", (Throwable)e);
            return null;
        }
    }

    public RemoteField[] convertFieldsToRemoteFields(Collection fields) {
        RemoteField[] remoteFields = new RemoteField[fields.size()];
        int i = 0;
        for (Field field : fields) {
            RemoteField remoteField;
            remoteFields[i] = remoteField = new RemoteField(field.getId(), field.getName());
            ++i;
        }
        return remoteFields;
    }

    public Map mapFieldValueToMap(RemoteFieldValue[] actionParams) {
        if (actionParams != null) {
            HashMap<String, String[]> map = new HashMap<String, String[]>(actionParams.length);
            for (int i = 0; i < actionParams.length; ++i) {
                RemoteFieldValue remoteFieldValue = actionParams[i];
                map.put(remoteFieldValue.getId(), remoteFieldValue.getValues());
            }
            return map;
        }
        return null;
    }

    public void updateIssue(MutableIssue issueObject, OperationContext operationContext, User user, ErrorCollection errors, I18nHelper i18n) throws RemoteException {
        try {
            ActionResult aResult = this.updateFieldsHelperBean.updateIssue(issueObject, operationContext, user, errors, i18n);
            ActionUtils.checkForErrors((ActionResult)aResult);
        }
        catch (Throwable e) {
            log.error((Object)("Exception occurred editing issue: " + e), e);
            throw new RemoteException("Error occurred editing issue: " + errors.getErrors() + " " + errors.getErrorMessages(), e);
        }
    }

    public void validate(Issue issueObject, OperationContext operationContext, Map actionParams, User user, ErrorCollection errors, I18nHelper i18n) throws RemoteException {
        try {
            this.updateFieldsHelperBean.validate(issueObject, operationContext, actionParams, user, errors, i18n);
        }
        catch (Throwable e) {
            log.error((Object)("Exception validating issue: " + e), e);
            throw new RemoteException("Error occurred validating issue: " + errors.getErrors() + " " + errors.getErrorMessages(), e);
        }
    }

    public RemoteField[] getFieldsForEdit(User user, Issue issueObject) {
        List fields = this.updateFieldsHelperBean.getFieldsForEdit(user, issueObject);
        return this.convertFieldsToRemoteFields(fields);
    }

    public RemoteField[] getFieldsForCreate(User user, Issue issue) {
        List fields = this.creationHelperBean.getFieldsForCreate(user, issue);
        return this.convertFieldsToRemoteFields(fields);
    }

    public User setRemoteUserInJira(User user) {
        User oldUser = this.authenticationContext.getLoggedInUser();
        this.authenticationContext.setLoggedInUser(user);
        return oldUser;
    }
}

