/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.util;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.soap.axis.SoapAttachmentHelper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Stub;
import org.apache.log4j.Logger;

public class PluginSoapAttachmentHelper
implements SoapAttachmentHelper {
    private static final Logger log = Logger.getLogger(PluginSoapAttachmentHelper.class);
    private final String attachmentsDir = System.getProperty("java.io.tmpdir");
    private static final String UNKOWN_FILE = "UnknownAttachment";

    public synchronized String[] addFiles(Stub stub, String[] fileLocations) {
        String[] fileNames = new String[fileLocations.length];
        for (int i = 0; i < fileLocations.length; ++i) {
            String fileName;
            File file = new File(fileLocations[i]);
            fileNames[i] = fileName = file.getName();
            DataHandler attachmentFile = new DataHandler((DataSource)new FileDataSource(file));
            stub._setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.mime");
            stub.addAttachment((Object)attachmentFile);
        }
        return fileNames;
    }

    public synchronized File[] saveFile(String[] attachmentFileNames) throws RemoteException {
        try {
            AttachmentPart[] attachments = this.getMessageAttachments();
            File[] returnedFiles = new File[attachments.length];
            if (attachments.length > attachmentFileNames.length) {
                log.warn((Object)"There are more attachments than stated names. They may be corrupted.");
                String[] oldFileNames = (String[])attachmentFileNames.clone();
                attachmentFileNames = new String[attachments.length];
                for (int i = 0; i < attachmentFileNames.length; ++i) {
                    attachmentFileNames[i] = i < oldFileNames.length ? oldFileNames[i] : UNKOWN_FILE;
                }
            }
            for (int i = 0; i < attachments.length; ++i) {
                DataHandler dh = attachments[i].getDataHandler();
                String name = attachmentFileNames[i];
                log.debug((Object)("File received on server is: " + name));
                File file = new File(this.attachmentsDir, name);
                FileOutputStream os = new FileOutputStream(file);
                dh.writeTo((OutputStream)os);
                ((OutputStream)os).close();
                returnedFiles[i] = file;
            }
            return returnedFiles;
        }
        catch (Exception e) {
            log.error((Object)("Unable to save file(s): " + e), (Throwable)e);
            AxisFault af = new AxisFault();
            af.setFaultCodeAsString("Server.UnableToSave");
            af.setFaultReason("Unable to save file(s): " + e);
            throw af;
        }
    }

    public synchronized void relayAttachments(Stub stub) throws RemoteException {
        try {
            stub._setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.mime");
            AttachmentPart[] attachments = this.getMessageAttachments();
            for (int i = 0; i < attachments.length; ++i) {
                DataHandler dh = attachments[i].getDataHandler();
                stub.addAttachment((Object)dh);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public DataHandler[] getDataHandlers() {
        try {
            AttachmentPart[] attachmentParts = this.getMessageAttachments();
            DataHandler[] attachments = new DataHandler[attachmentParts.length];
            for (int i = 0; i < attachmentParts.length; ++i) {
                AttachmentPart attachmentPart = attachmentParts[i];
                attachments[i] = attachmentPart.getDataHandler();
            }
            return attachments;
        }
        catch (Exception axisFault) {
            log.error((Object)axisFault);
            return null;
        }
    }

    private AttachmentPart[] getMessageAttachments() throws AxisFault {
        Attachments messageAttachments = MessageContext.getCurrentContext().getRequestMessage().getAttachmentsImpl();
        if (null == messageAttachments) {
            log.warn((Object)"No attachment support");
            return new AttachmentPart[0];
        }
        int attachmentCount = messageAttachments.getAttachmentCount();
        AttachmentPart[] attachments = new AttachmentPart[attachmentCount];
        Iterator it = messageAttachments.getAttachments().iterator();
        int count = 0;
        while (it.hasNext()) {
            AttachmentPart part = (AttachmentPart)it.next();
            attachments[count++] = part;
        }
        return attachments;
    }

    public static PluginSoapAttachmentHelper getInstance() {
        return new PluginSoapAttachmentHelper();
    }

    public File byteArrayToTempFile(byte[] buffer) {
        if (buffer.length > 0) {
            FileOutputStream destFile = null;
            try {
                File tempFile = File.createTempFile("jira-soap", "tmp");
                destFile = new FileOutputStream(tempFile);
                DataOutputStream fstream = new DataOutputStream(destFile);
                fstream.write(buffer, 0, buffer.length);
                fstream.flush();
                File file = tempFile;
                return file;
            }
            catch (IOException e) {
                throw new DataAccessException("Unable to write to temp file for SOAP", (Throwable)e);
            }
            finally {
                if (destFile != null) {
                    try {
                        destFile.close();
                    }
                    catch (IOException e2) {
                        throw new DataAccessException("Unable to close file for SOAP", (Throwable)e2);
                    }
                }
            }
        }
        return null;
    }
}

