/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.core.user.GroupUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.group.GroupRemoveUserMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.service.UserService;
import com.atlassian.jira.rpc.soap.util.RemoteEntityFactory;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServiceImpl
implements UserService {
    private PermissionManager permissionManager;
    private SearchRequestService searchRequestService;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private ApplicationProperties applicationProperties;
    private final GroupService groupService;
    private com.atlassian.jira.bc.user.UserService userService;
    private final RemoteEntityFactory remoteEntityFactory;
    private final CrowdService crowdService;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserUtil userUtil;

    public UserServiceImpl(SearchRequestService searchRequestService, UserManager userManager, GroupManager groupManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, com.atlassian.jira.bc.user.UserService userService, GroupService groupService, RemoteEntityFactory remoteEntityFactory, CrowdService crowdService, GlobalPermissionManager globalPermissionManager, UserUtil userUtil) {
        this.searchRequestService = searchRequestService;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.userService = userService;
        this.groupService = groupService;
        this.remoteEntityFactory = remoteEntityFactory;
        this.crowdService = crowdService;
        this.globalPermissionManager = globalPermissionManager;
        this.userUtil = userUtil;
    }

    @Override
    public RemoteUser getUser(User currentUser, String username) {
        User foundUser = this.userManager.getUserObject(username);
        if (foundUser == null) {
            return null;
        }
        return this.remoteEntityFactory.createUser(foundUser);
    }

    @Override
    public RemoteUser createUser(User remoteUser, String username, String password, String fullName, String email) throws RemoteValidationException, RemotePermissionException {
        UserService.CreateUserValidationResult result;
        if (username != null) {
            username = username.trim();
        }
        if (!(result = this.userService.validateCreateUserForAdminPasswordRequired(remoteUser, username, password, password, email, fullName)).isValid()) {
            throw new RemoteValidationException("Error creating user", result.getErrorCollection());
        }
        try {
            User user = this.userService.createUserWithNotification(result);
            return this.remoteEntityFactory.createUser(user);
        }
        catch (PermissionException e) {
            throw new RemoteValidationException("cannot create user details, cause: " + e.getMessage(), e);
        }
        catch (CreateException e) {
            throw new RemoteValidationException("cannot create user details, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public RemoteUser updateUser(User admin, RemoteUser remoteUser) throws RemoteValidationException, RemoteException {
        User updatedUser = this.canUpdateUser(admin, remoteUser);
        User updatedUserDetails = this.updatedTheUserDetails(updatedUser, remoteUser);
        return this.getUser(admin, updatedUserDetails.getName());
    }

    @Override
    public RemoteUser setUserPassword(User admin, RemoteUser remoteUser, String newPassword) throws RemoteValidationException, RemoteException {
        User updatedUser = this.canUpdateUser(admin, remoteUser);
        this.updatedTheUserPassword(updatedUser, newPassword);
        return this.getUser(admin, updatedUser.getName());
    }

    private User canUpdateUser(User admin, RemoteUser remoteUser) throws RemoteValidationException {
        if (admin != null && admin.getName().equals(remoteUser.getName())) {
            return admin;
        }
        if (!this.isAdministrator(admin) && !this.isSystemAdministrator(admin)) {
            throw new RemoteValidationException(String.format("The user: %s does not have permission to update the user: %s", admin.getName(), remoteUser.getName()));
        }
        User updatedUser = this.userManager.getUserObject(remoteUser.getName());
        if (updatedUser == null) {
            throw new RemoteValidationException(String.format("No user could be found with the name: %s", remoteUser.getName()));
        }
        if (!this.isRemoteUserPermittedToEditSelectedUser(admin, updatedUser)) {
            throw new RemoteValidationException(String.format("The user: %s does not have permission to update the user: %s", admin.getName(), remoteUser.getName()));
        }
        if (!this.userManager.canUpdateUser(updatedUser)) {
            throw new RemoteValidationException(String.format("The user: %s is in a read-only directory", remoteUser.getName()));
        }
        return updatedUser;
    }

    private User updatedTheUserDetails(User updatedUser, RemoteUser remoteUser) throws RemoteException {
        UserTemplate user = new UserTemplate(updatedUser);
        user.setDisplayName(remoteUser.getFullname());
        user.setEmailAddress(remoteUser.getEmail());
        try {
            return this.crowdService.updateUser((User)user);
        }
        catch (OperationNotPermittedException e) {
            throw new RemoteException(e.toString());
        }
        catch (OperationFailedException e) {
            throw new RemoteException(e.toString());
        }
        catch (InvalidUserException e) {
            throw new RemoteException(e.toString());
        }
    }

    private void updatedTheUserPassword(User updatedUser, String newPassword) throws RemoteException {
        try {
            this.userUtil.changePassword(updatedUser, newPassword);
        }
        catch (UserNotFoundException e) {
            throw new RemoteException(e.toString());
        }
        catch (InvalidCredentialException e) {
            throw new RemoteException(e.toString());
        }
        catch (OperationNotPermittedException e) {
            throw new RemoteException(e.toString());
        }
        catch (PermissionException e) {
            throw new RemoteException(e.toString());
        }
    }

    public boolean isRemoteUserPermittedToEditSelectedUser(User admin, User updatedUser) {
        return this.isSystemAdministrator(admin) || !this.isSystemAdministrator(updatedUser);
    }

    private boolean isSystemAdministrator(User admin) {
        return this.globalPermissionManager.hasPermission(44, admin);
    }

    private boolean isAdministrator(User admin) {
        return this.globalPermissionManager.hasPermission(0, admin);
    }

    @Override
    public void deleteUser(User remoteUser, String username) throws RemoteException {
        UserService.DeleteUserValidationResult result = this.userService.validateDeleteUser(remoteUser, username);
        if (!result.isValid()) {
            throw new RemoteValidationException("Error removing user", result.getErrorCollection());
        }
        try {
            this.userService.removeUser(remoteUser, result);
        }
        catch (Exception e) {
            throw new RemoteException("Unable to delete user, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public RemoteGroup getGroup(User admin, String groupName) throws RemoteException {
        if (!this.permissionManager.hasPermission(0, admin)) {
            throw new RemotePermissionException("You do not have permission to get a group.");
        }
        if (groupName == null) {
            throw new RemoteValidationException("group name cannot be null, needs a value");
        }
        com.opensymphony.user.Group group = GroupUtils.getGroup((String)groupName);
        if (group == null) {
            throw new RemoteValidationException("no group found for that groupName: " + groupName);
        }
        return this.remoteEntityFactory.createGroup((Group)group);
    }

    @Override
    public RemoteGroup createGroup(User admin, String groupName, RemoteUser firstUser) throws RemoteException {
        Group group;
        if (!this.permissionManager.hasPermission(0, admin)) {
            throw new RemotePermissionException("You do not have permission to create a group.");
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            throw new RemoteValidationException("Cannot create group, as external user management is enabled. Contact your administrator.");
        }
        if (groupName == null) {
            throw new RemoteValidationException("group cannot be created, group name cannot be null, needs a value");
        }
        User osFirstUser = null;
        if (firstUser != null && (osFirstUser = this.userManager.getUserObject(firstUser.getName())) == null) {
            throw new RemoteValidationException("group cannot be created, first user '" + firstUser.getName() + "' for this group doesn't exist");
        }
        try {
            group = this.groupManager.createGroup(groupName);
            if (osFirstUser != null) {
                this.groupManager.addUserToGroup(osFirstUser, group);
            }
        }
        catch (Exception e) {
            throw new RemoteValidationException("Group '" + groupName + "' cannot be created. " + e.getMessage(), e);
        }
        return this.remoteEntityFactory.createGroup(group);
    }

    @Override
    public void addUserToGroup(User admin, RemoteGroup remoteGroup, RemoteUser remoteUser) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        List groups = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateAddUserToGroup((JiraServiceContext)jiraServiceContext, (Collection)groups, remoteUser.getName()) && this.groupService.addUsersToGroups((JiraServiceContext)jiraServiceContext, (Collection)groups, (Collection)EasyList.build((Object)remoteUser.getName()))) {
            return;
        }
        throw new RemoteValidationException("Can not add user '" + remoteUser.getName() + "' to group '" + remoteGroup.getName() + "'.", (ErrorCollection)errorCollection);
    }

    @Override
    public void removeUserFromGroup(User admin, RemoteGroup remoteGroup, RemoteUser remoteUser) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        List groups = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateRemoveUserFromGroups((JiraServiceContext)jiraServiceContext, groups, remoteUser.getName())) {
            GroupRemoveUserMapper groupRemoveUserMapper = new GroupRemoveUserMapper();
            groupRemoveUserMapper.register(remoteUser.getName(), remoteGroup.getName());
            if (this.groupService.removeUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper)) {
                return;
            }
        }
        throw new RemoteValidationException("Can not remove user '" + remoteUser.getName() + "' from group '" + remoteGroup.getName() + "'.", (ErrorCollection)errorCollection);
    }

    @Override
    public RemoteGroup updateGroup(User admin, RemoteGroup remoteGroup) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        Group group = this.getGroup(remoteGroup);
        Collection<String> userNamesToAdd = this.getUsersToAddToGroup(remoteGroup, group);
        this.addUsersToGroup(remoteGroup, jiraServiceContext, userNamesToAdd, (ErrorCollection)errorCollection);
        this.removeUsersFromGroup(group, remoteGroup, jiraServiceContext, (ErrorCollection)errorCollection);
        return this.remoteEntityFactory.createGroup(group);
    }

    private void removeUsersFromGroup(Group group, RemoteGroup remoteGroup, JiraServiceContextImpl jiraServiceContext, ErrorCollection errorCollection) throws RemoteValidationException {
        GroupRemoveUserMapper groupRemoveUserMapper = this.getRemoveUserMapper(group, remoteGroup);
        if (this.groupService.validateRemoveUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper) && this.groupService.removeUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper)) {
            return;
        }
        throw new RemoteValidationException("Errors during update group. Error with removing users from the group.", errorCollection);
    }

    private void addUsersToGroup(RemoteGroup remoteGroup, JiraServiceContextImpl jiraServiceContext, Collection<String> userNamesToAdd, ErrorCollection errorCollection) throws RemoteValidationException {
        List groupsToJoin = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateAddUsersToGroup((JiraServiceContext)jiraServiceContext, (Collection)groupsToJoin, userNamesToAdd).isSuccess()) {
            this.groupService.addUsersToGroups((JiraServiceContext)jiraServiceContext, (Collection)groupsToJoin, userNamesToAdd);
        }
        if (errorCollection.hasAnyErrors()) {
            throw new RemoteValidationException("Errors during update group. Error with adding users to the group.", errorCollection);
        }
    }

    private GroupRemoveUserMapper getRemoveUserMapper(Group group, RemoteGroup remoteGroup) {
        GroupRemoveUserMapper groupRemoveUserMapper = new GroupRemoveUserMapper(EasyList.build((Object)remoteGroup.getName()));
        Collection users = this.groupManager.getUsersInGroup(group.getName());
        for (User user : users) {
            String userName = user.getName();
            if (this.groupContainsUserWithUsername(userName, remoteGroup)) continue;
            groupRemoveUserMapper.register(userName);
        }
        return groupRemoveUserMapper;
    }

    private Collection<String> getUsersToAddToGroup(RemoteGroup remoteGroup, Group group) {
        ArrayList<String> userNamesToAdd = new ArrayList<String>();
        for (int i = 0; i < remoteGroup.getUsers().length; ++i) {
            User user;
            RemoteUser remoteUser = remoteGroup.getUsers()[i];
            if (remoteUser == null || (user = this.userManager.getUserObject(remoteUser.getName())) != null && this.groupManager.isUserInGroup(user, group)) continue;
            userNamesToAdd.add(remoteUser.getName());
        }
        return userNamesToAdd;
    }

    private boolean groupContainsUserWithUsername(String username, RemoteGroup group) {
        for (int i = 0; i < group.getUsers().length; ++i) {
            RemoteUser remoteUser = group.getUsers()[i];
            if (remoteUser.getName() == null || !remoteUser.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    private Group getGroup(RemoteGroup remoteGroup) throws RemotePermissionException, RemoteValidationException {
        com.opensymphony.user.Group group = GroupUtils.getGroup((String)remoteGroup.getName());
        if (group == null) {
            throw new RemoteValidationException("group cannot be updated, because it doesn't exist.");
        }
        return group;
    }

    @Override
    public void deleteGroup(User admin, String groupName, String swapGroupName) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        if (!this.groupService.validateDelete((JiraServiceContext)jiraServiceContext, groupName, swapGroupName)) {
            throw new RemoteValidationException("Error validating group deletion.", (ErrorCollection)errorCollection);
        }
        if (!this.groupService.delete((JiraServiceContext)jiraServiceContext, groupName, swapGroupName)) {
            throw new RemoteValidationException("Error deleting group.", (ErrorCollection)errorCollection);
        }
    }

    @Override
    public RemoteFilter[] getFavouriteFilters(User user) throws RemoteException {
        return SoapUtils.getFilters(this.searchRequestService.getFavouriteFilters(user));
    }
}

