/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.service.ProjectService;
import com.atlassian.jira.rpc.soap.service.ServiceHelper;
import com.atlassian.jira.rpc.soap.util.RemoteEntityFactory;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Base64InputStreamConsumer;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ProjectServiceImpl
implements ProjectService {
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final NotificationSchemeManager notificationSchemeManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final com.atlassian.jira.bc.project.ProjectService projectService;
    private final ProjectComponentManager projectComponentManager;
    private final VersionService versionService;
    private final OutlookDateManager outlookDateManager;
    private final UserManager userManager;
    private AvatarManager avatarManager;
    private final RemoteEntityFactory remoteEntityFactory;
    private static final Logger log = Logger.getLogger(ProjectServiceImpl.class);
    private static final String AVATAR_DEFAULT_BASE_FILENAME = "soapCreatedAvatar";
    private static final String BASE_64_TEXT_ENCODING = "UTF-8";

    public ProjectServiceImpl(PermissionManager permissionManager, ApplicationProperties applicationProperties, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager, com.atlassian.jira.bc.project.ProjectService projectService, ProjectComponentManager projectComponentManager, VersionService versionService, OutlookDateManager outlookDateManager, UserManager userManager, AvatarManager avatarManager, RemoteEntityFactory remoteEntityFactory) {
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.projectService = projectService;
        this.projectComponentManager = projectComponentManager;
        this.versionService = versionService;
        this.outlookDateManager = outlookDateManager;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.remoteEntityFactory = remoteEntityFactory;
    }

    public RemoteProject[] getProjects(User user, boolean addSchemes) throws RemoteException {
        try {
            Collection projects = this.permissionManager.getProjects(10, user);
            RemoteProject[] remoteProjects = SoapUtils.getProjects(projects, this.applicationProperties);
            if (addSchemes) {
                ArrayList projs = new ArrayList(projects);
                for (int i = 0; i < remoteProjects.length; ++i) {
                    this.addRemoteSchemes(user, remoteProjects[i], (GenericValue)projs.get(i));
                }
            }
            return remoteProjects;
        }
        catch (GenericEntityException e) {
            throw new RemoteException("Error getting projects: " + (Object)((Object)e), e);
        }
    }

    public RemoteProject getProjectById(User user, Long projectId) throws RemoteException {
        Project project = this.retrieveProjectById(projectId, user);
        return new RemoteProject(project, this.applicationProperties);
    }

    public RemoteProject getProjectWithSchemesById(User user, Long projectId) throws RemoteException {
        try {
            Project project = this.retrieveProjectById(projectId, user);
            RemoteProject remoteProject = new RemoteProject(project, this.applicationProperties);
            this.addRemoteSchemes(user, remoteProject, project.getGenericValue());
            return remoteProject;
        }
        catch (GenericEntityException e) {
            throw new RemoteException("Error getting schemes for project with id: " + projectId, e);
        }
    }

    public RemoteProject getProjectByKey(User user, String projectKey) throws RemoteException {
        Project project = this.retrieveProjectByKey(projectKey, user);
        return new RemoteProject(project, this.applicationProperties);
    }

    public RemoteComponent[] getComponents(User user, String projectKey) throws RemoteException {
        try {
            Project project = this.retrieveProjectByKey(projectKey, user);
            Collection components = this.projectComponentManager.findAllForProject(project.getId());
            return SoapUtils.convertComponentsToRemoteObject(components);
        }
        catch (DataAccessException e) {
            throw new RemoteException("Error retrieving components: " + (Object)((Object)e), e);
        }
    }

    public RemoteVersion[] getVersions(User user, String projectKey) throws RemoteException {
        try {
            Project project = this.retrieveProjectByKey(projectKey, user);
            VersionService.VersionsResult result = this.versionService.getVersionsByProject(user, project);
            if (!result.isValid()) {
                throw new RemoteValidationException("Error retrieving versions: ", result.getErrorCollection());
            }
            return SoapUtils.convertVersionsToRemoteObject(result.getVersions());
        }
        catch (DataAccessException e) {
            throw new RemoteException("Error retrieving versions: " + (Object)((Object)e), e);
        }
    }

    public RemoteProject createProject(User user, RemoteProject rProject) throws RemoteException {
        Long permissionSchemeId = rProject.getPermissionScheme() == null ? null : rProject.getPermissionScheme().getId();
        Long notificationSchemeId = rProject.getNotificationScheme() == null ? null : rProject.getNotificationScheme().getId();
        Long issueSecuritySchemeId = rProject.getIssueSecurityScheme() == null ? null : rProject.getIssueSecurityScheme().getId();
        ProjectService.CreateProjectValidationResult result = this.projectService.validateCreateProject(user, rProject.getName(), rProject.getKey(), rProject.getDescription(), rProject.getLead(), rProject.getProjectUrl(), null);
        ProjectService.UpdateProjectSchemesValidationResult schemesResult = this.projectService.validateUpdateProjectSchemes(user, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorCollection(result.getErrorCollection());
        errors.addErrorCollection(schemesResult.getErrorCollection());
        if (errors.hasAnyErrors()) {
            throw new RemoteValidationException("Cannot create project: ", (ErrorCollection)errors);
        }
        Project newProject = this.projectService.createProject(result);
        this.projectService.updateProjectSchemes(schemesResult, newProject);
        RemoteProject remoteProject = new RemoteProject(newProject, this.applicationProperties);
        remoteProject.setNotificationScheme(rProject.getNotificationScheme());
        remoteProject.setPermissionScheme(rProject.getPermissionScheme());
        remoteProject.setIssueSecurityScheme(rProject.getIssueSecurityScheme());
        return remoteProject;
    }

    public RemoteProject createProject(User user, String key, String name, String description, String url, String lead, RemotePermissionScheme permissionScheme, RemoteScheme notificationScheme, RemoteScheme issueSecurityScheme) throws RemoteException {
        RemoteProject rProject = new RemoteProject();
        rProject.setKey(key);
        rProject.setName(name);
        rProject.setDescription(description);
        rProject.setUrl(this.applicationProperties.getString("jira.baseurl") + "/browse/" + key);
        rProject.setProjectUrl(url);
        rProject.setLead(lead);
        rProject.setPermissionScheme(permissionScheme);
        rProject.setNotificationScheme(notificationScheme);
        rProject.setIssueSecurityScheme(issueSecurityScheme);
        return this.createProject(user, rProject);
    }

    public RemoteProject updateProject(User user, RemoteProject rProject) throws RemoteException {
        Long permissionSchemeId = rProject.getPermissionScheme() == null ? null : rProject.getPermissionScheme().getId();
        Long notificationSchemeId = rProject.getNotificationScheme() == null ? null : rProject.getNotificationScheme().getId();
        Long issueSecuritySchemeId = rProject.getIssueSecurityScheme() == null ? null : rProject.getIssueSecurityScheme().getId();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(user, rProject.getName(), rProject.getKey(), rProject.getDescription(), rProject.getLead(), rProject.getProjectUrl(), null);
        ProjectService.UpdateProjectSchemesValidationResult schemesResult = this.projectService.validateUpdateProjectSchemes(user, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorCollection(result.getErrorCollection());
        errors.addErrorCollection(schemesResult.getErrorCollection());
        if (errors.hasAnyErrors()) {
            throw new RemoteValidationException("Cannot update project: ", (ErrorCollection)errors);
        }
        Project updatedProject = this.projectService.updateProject(result);
        this.projectService.updateProjectSchemes(schemesResult, updatedProject);
        RemoteProject remoteProject = new RemoteProject(updatedProject, this.applicationProperties);
        remoteProject.setNotificationScheme(rProject.getNotificationScheme());
        remoteProject.setPermissionScheme(rProject.getPermissionScheme());
        remoteProject.setIssueSecurityScheme(rProject.getIssueSecurityScheme());
        return remoteProject;
    }

    public void deleteProject(User user, String projectKey) throws RemoteException {
        ProjectService.DeleteProjectValidationResult result = this.projectService.validateDeleteProject(user, projectKey);
        if (!result.isValid()) {
            throw new RemoteValidationException("Error removing project: ", result.getErrorCollection());
        }
        ProjectService.DeleteProjectResult deleteResult = this.projectService.deleteProject(user, result);
        if (!deleteResult.isValid()) {
            throw new RemoteValidationException("Error removing project: ", deleteResult.getErrorCollection());
        }
    }

    void addRemoteSchemes(User user, RemoteProject remoteProject, GenericValue project) throws GenericEntityException, RemoteException {
        Iterator it;
        List issueSecuritySchemes;
        Iterator it2;
        List permissionSchemes;
        Iterator it3;
        List notificationSchemes = this.notificationSchemeManager.getSchemes(project);
        if (notificationSchemes != null && (it3 = notificationSchemes.iterator()).hasNext()) {
            GenericValue notificationScheme = (GenericValue)it3.next();
            remoteProject.setNotificationScheme(new RemoteScheme(notificationScheme, "notification"));
        }
        if ((permissionSchemes = this.permissionSchemeManager.getSchemes(project)) != null && (it2 = permissionSchemes.iterator()).hasNext()) {
            GenericValue permissionScheme = (GenericValue)it2.next();
            SchemePermissions schemePermissions = new SchemePermissions();
            ServiceHelper serviceHelper = new ServiceHelper(this.permissionManager, this.permissionSchemeManager, schemePermissions, this.remoteEntityFactory, this.userManager);
            RemotePermissionScheme scheme = null;
            try {
                scheme = serviceHelper.populateSchemePermissions(user, permissionScheme);
            }
            catch (Exception e) {
                scheme = new RemotePermissionScheme(permissionScheme);
            }
            remoteProject.setPermissionScheme(scheme);
        }
        if ((issueSecuritySchemes = this.issueSecuritySchemeManager.getSchemes(project)) != null && (it = issueSecuritySchemes.iterator()).hasNext()) {
            GenericValue issueSecurityScheme = (GenericValue)it.next();
            remoteProject.setIssueSecurityScheme(new RemoteScheme(issueSecurityScheme, "issueSecurity"));
        }
    }

    Project retrieveProjectById(Long id, User user) throws RemoteException {
        ProjectService.GetProjectResult result = this.projectService.getProjectById(user, id);
        if (!result.isValid()) {
            throw new RemoteValidationException("Error retrieving project with id '" + id + "':", result.getErrorCollection());
        }
        return result.getProject();
    }

    Project retrieveProjectByKey(String projectKey, User user) throws RemoteException {
        try {
            ProjectService.GetProjectResult result = this.projectService.getProjectByKey(user, projectKey);
            if (!result.isValid()) {
                throw new RemoteValidationException("Error retrieving project with key '" + projectKey + "':", result.getErrorCollection());
            }
            return result.getProject();
        }
        catch (DataAccessException e) {
            throw new RemoteException("Error retrieving project: " + projectKey, e);
        }
    }

    public RemoteVersion createVersion(User user, String projectKey, RemoteVersion remoteVersion) throws RemoteException {
        Project project = this.retrieveProjectByKey(projectKey, user);
        I18nBean i18nBean = new I18nBean(user);
        OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(i18nBean.getLocale());
        String releaseDate = remoteVersion.getReleaseDate() != null ? outlookDate.formatDatePicker(remoteVersion.getReleaseDate()) : null;
        Long scheduleAfterVersion = this.getScheduleAfter(user, project, remoteVersion);
        VersionService.CreateVersionValidationResult result = this.versionService.validateCreateVersion(user, project, remoteVersion.getName(), releaseDate, null, scheduleAfterVersion);
        if (!result.isValid()) {
            throw new RemoteValidationException("createVersion validation error: ", result.getErrorCollection());
        }
        try {
            Version version = this.versionService.createVersion(user, result);
            if (remoteVersion.isReleased()) {
                VersionService.ReleaseVersionValidationResult releaseResult = this.versionService.validateReleaseVersion(user, version, remoteVersion.getReleaseDate());
                if (!releaseResult.isValid()) {
                    throw new RemoteValidationException("Release version: ", releaseResult.getErrorCollection());
                }
                version = this.versionService.releaseVersion(releaseResult);
            } else if (remoteVersion.isArchived()) {
                VersionService.ArchiveVersionValidationResult archiveResult = this.versionService.validateArchiveVersion(user, version);
                if (!archiveResult.isValid()) {
                    throw new RemoteValidationException("Archive version: ", archiveResult.getErrorCollection());
                }
                version = this.versionService.archiveVersion(archiveResult);
            }
            return new RemoteVersion(version.getGenericValue());
        }
        catch (Exception e) {
            throw new RemoteException("Error creating version", e);
        }
    }

    private Version getVersionByProjectAndName(User user, String projectKey, String versionName) throws RemoteException {
        Project project = this.retrieveProjectByKey(projectKey, user);
        VersionService.VersionResult versionResult = this.versionService.getVersionByProjectAndName(user, project, versionName);
        if (!versionResult.isValid()) {
            throw new RemoteValidationException("Version not found: ", versionResult.getErrorCollection());
        }
        return versionResult.getVersion();
    }

    public void releaseVersion(User user, String projectKey, RemoteVersion remoteVersion) throws RemoteException {
        Version version = this.getVersionByProjectAndName(user, projectKey, remoteVersion.getName());
        if (remoteVersion.isReleased()) {
            VersionService.ReleaseVersionValidationResult result = this.versionService.validateReleaseVersion(user, version, remoteVersion.getReleaseDate());
            if (!result.isValid()) {
                throw new RemoteValidationException("Release version: ", result.getErrorCollection());
            }
            this.versionService.releaseVersion(result);
        } else {
            VersionService.ReleaseVersionValidationResult result = this.versionService.validateUnreleaseVersion(user, version, remoteVersion.getReleaseDate());
            if (!result.isValid()) {
                throw new RemoteValidationException("Unrelease version: ", result.getErrorCollection());
            }
            this.versionService.unreleaseVersion(result);
        }
    }

    public void archiveVersion(User user, String projectKey, String versionName, boolean archive) throws RemoteException {
        Version version = this.getVersionByProjectAndName(user, projectKey, versionName);
        if (archive) {
            VersionService.ArchiveVersionValidationResult result = this.versionService.validateArchiveVersion(user, version);
            if (!result.isValid()) {
                throw new RemoteValidationException("Archive version: ", result.getErrorCollection());
            }
            this.versionService.archiveVersion(result);
        } else {
            VersionService.ArchiveVersionValidationResult result = this.versionService.validateUnarchiveVersion(user, version);
            if (!result.isValid()) {
                throw new RemoteValidationException("Unarchive version: ", result.getErrorCollection());
            }
            this.versionService.unarchiveVersion(result);
        }
    }

    public RemoteSecurityLevel[] getSecurityLevels(User user, String projectKey) throws RemoteException {
        List usersSecurityLevels;
        Project project = this.retrieveProjectByKey(projectKey, user);
        if (!this.permissionManager.hasPermission(26, project, user)) {
            return new RemoteSecurityLevel[0];
        }
        try {
            usersSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(project.getGenericValue(), user);
        }
        catch (GenericEntityException e) {
            throw new RemoteException("Error getting security levels for project '" + projectKey + "'" + e.getMessage(), e);
        }
        RemoteSecurityLevel[] remoteSecurityLevels = new RemoteSecurityLevel[usersSecurityLevels.size()];
        for (int i = 0; i < usersSecurityLevels.size(); ++i) {
            remoteSecurityLevels[i] = new RemoteSecurityLevel((GenericValue)usersSecurityLevels.get(i));
        }
        return remoteSecurityLevels;
    }

    public RemoteAvatar[] getProjectAvatars(User user, String projectKey, boolean includeSystemAvatars, String size) throws RemoteException, RemotePermissionException {
        boolean large = "large".equalsIgnoreCase(size);
        Project project = this.retrieveProjectByKey(projectKey, user);
        ArrayList avatars = new ArrayList();
        if (includeSystemAvatars) {
            avatars.addAll(this.avatarManager.getAllSystemAvatars(Avatar.Type.PROJECT));
        }
        avatars.addAll(this.avatarManager.getCustomAvatarsForOwner(Avatar.Type.PROJECT, project.getId().toString()));
        RemoteAvatar[] remoteAvatars = new RemoteAvatar[avatars.size()];
        for (int i = 0; i < avatars.size(); ++i) {
            remoteAvatars[i] = this.createRemoteAvatar((Avatar)avatars.get(i), large, new Base64InputStreamConsumer(true));
        }
        return remoteAvatars;
    }

    public void setProjectAvatar(User user, String projectKey, String contentType, String base64ImageData) throws RemoteException {
        Project project = this.retrieveProjectForAdministration(user, projectKey);
        String owner = project.getId().toString();
        try {
            byte[] decoded = Base64.decodeBase64((byte[])base64ImageData.getBytes(BASE_64_TEXT_ENCODING));
            ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
            AvatarImpl toCreate = AvatarImpl.createCustomAvatar((String)AVATAR_DEFAULT_BASE_FILENAME, (String)contentType, (Avatar.Type)Avatar.Type.PROJECT, (String)owner);
            Avatar createdAvatar = this.avatarManager.create((Avatar)toCreate, (InputStream)bais, AvatarManager.LARGE.originSelection());
            IOUtil.shutdownStream((InputStream)bais);
            Long avatarId = createdAvatar.getId();
            ProjectService.UpdateProjectValidationResult result = this.validateSetAvatar(user, project, avatarId);
            if (!result.isValid()) {
                log.error((Object)"Problem setting avatar on project, removing SOAP created avatar");
                this.avatarManager.delete(createdAvatar.getId(), true);
                throw new RemoteException("Error setting Avatar on project: " + result.getErrorCollection());
            }
            this.projectService.updateProject(result);
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void setProjectAvatar(User user, String projectKey, Long avatarId) throws RemoteException {
        Project project = this.retrieveProjectForAdministration(user, projectKey);
        ProjectService.UpdateProjectValidationResult result = this.validateSetAvatar(user, project, avatarId);
        if (!result.isValid()) {
            throw new RemoteException("Error setting Avatar on project: " + result.getErrorCollection());
        }
        this.projectService.updateProject(result);
    }

    public RemoteAvatar getProjectAvatar(User user, String projectKey, String size) throws RemoteException, RemotePermissionException {
        boolean large = "large".equalsIgnoreCase(size);
        Project project = this.retrieveProjectByKey(projectKey, user);
        return this.createRemoteAvatar(project.getAvatar(), large, new Base64InputStreamConsumer(true));
    }

    public void deleteProjectAvatar(User user, long avatarId) throws RemoteException {
        boolean deletingTheCurrentAvatar;
        Avatar avatar = this.avatarManager.getById(Long.valueOf(avatarId));
        if (avatar == null || avatar.isSystemAvatar() || avatar.getOwner() == null) {
            throw new RemoteException("No such custom Avatar with id " + avatarId);
        }
        Project project = this.retrieveProjectForAdministration(user, Long.valueOf(avatar.getOwner()));
        boolean bl = deletingTheCurrentAvatar = project.getAvatar().getId() == avatarId;
        if (deletingTheCurrentAvatar) {
            Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
            ProjectService.UpdateProjectValidationResult updateProjectValidationResult = this.validateSetAvatar(user, project, defaultAvatarId);
            if (updateProjectValidationResult.isValid()) {
                this.projectService.updateProject(updateProjectValidationResult);
                this.avatarManager.delete(Long.valueOf(avatarId), true);
            }
        } else {
            this.avatarManager.delete(Long.valueOf(avatarId), true);
        }
    }

    RemoteAvatar createRemoteAvatar(Avatar a, boolean large, Base64InputStreamConsumer data) {
        long id = a.getId();
        String contentType = a.getContentType();
        String type = a.getAvatarType().getName();
        try {
            if (large) {
                this.avatarManager.readLargeAvatarData(a, (Consumer)data);
            } else {
                this.avatarManager.readSmallAvatarData(a, (Consumer)data);
            }
        }
        catch (IOException e) {
            log.error((Object)"Exception trying to get Avatar image data, continuing without it", (Throwable)e);
        }
        return new RemoteAvatar(id, contentType, a.getOwner(), a.isSystemAvatar(), type, data.getEncoded());
    }

    ProjectService.UpdateProjectValidationResult validateSetAvatar(User user, Project project, Long avatarId) {
        Long effectiveAvatarId = avatarId == null ? this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT) : avatarId;
        return this.projectService.validateUpdateProject(user, project.getName(), project.getKey(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), effectiveAvatarId);
    }

    private Project retrieveProjectForAdministration(User user, long projectId) throws RemoteException {
        Project project = this.retrieveProjectById(projectId, user);
        if (!this.permissionManager.hasPermission(0, user) && !this.permissionManager.hasPermission(23, project, user)) {
            throw new RemotePermissionException("No permission to administer the project");
        }
        return project;
    }

    private Project retrieveProjectForAdministration(User user, String projectKey) throws RemoteException {
        Project project = this.retrieveProjectByKey(projectKey, user);
        if (!this.permissionManager.hasPermission(0, user) && !this.permissionManager.hasPermission(23, project, user)) {
            throw new RemotePermissionException("No permission to administer the project");
        }
        return project;
    }

    private Long getScheduleAfter(User user, Project project, RemoteVersion remoteVersion) throws RemoteValidationException {
        Long sequence = remoteVersion.getSequence();
        if (sequence != null && sequence != -1L) {
            int seq = (int)sequence.longValue() - 1;
            VersionService.VersionsResult result = this.versionService.getVersionsByProject(user, project);
            if (!result.isValid()) {
                throw new RemoteValidationException("Error retrieving versions: ", result.getErrorCollection());
            }
            ArrayList versions = new ArrayList(result.getVersions());
            if (seq > versions.size()) {
                return null;
            }
            if (seq < 1) {
                return -1L;
            }
            Version v = (Version)versions.get(seq - 1);
            return v.getId();
        }
        return sequence;
    }
}

