/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import com.atlassian.jira.rpc.soap.beans.RemotePriority;
import com.atlassian.jira.rpc.soap.beans.RemoteResolution;
import com.atlassian.jira.rpc.soap.beans.RemoteStatus;
import com.atlassian.jira.rpc.soap.service.IssueConstantsService;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.security.PermissionManager;

public class IssueConstantsServiceImpl
implements IssueConstantsService {
    private ConstantsManager constantsManager;
    private PermissionManager permissionManager;
    private IssueTypeSchemeManager issueTypeSchemeManager;
    private final ProjectManager projectManager;

    public IssueConstantsServiceImpl(ConstantsManager constantsManager, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager) {
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.projectManager = projectManager;
    }

    public RemoteIssueType[] getIssueTypesForProject(User user, String projectId) throws RemotePermissionException {
        Project project;
        if (projectId != null && (project = this.projectManager.getProjectObj(new Long(projectId))) != null) {
            this.confirmUserHasBrowseProjectPermission(user, project);
            return SoapUtils.getIssueTypeObjects(this.issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project));
        }
        return new RemoteIssueType[0];
    }

    public RemoteIssueType[] getSubTaskIssueTypesForProject(User user, String projectId) throws RemotePermissionException {
        Project project;
        if (projectId != null && (project = this.projectManager.getProjectObj(new Long(projectId))) != null) {
            this.confirmUserHasBrowseProjectPermission(user, project);
            return SoapUtils.getIssueTypeObjects(this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(project));
        }
        return new RemoteIssueType[0];
    }

    public RemoteIssueType[] getIssueTypes(User user) throws RemotePermissionException {
        this.confirmUserHasABrowseProjectPermission(user);
        return SoapUtils.getIssueTypes(this.constantsManager.getIssueTypes());
    }

    public RemoteIssueType[] getSubTaskIssueTypes(User user) throws RemotePermissionException {
        this.confirmUserHasABrowseProjectPermission(user);
        return SoapUtils.getIssueTypes(this.constantsManager.getSubTaskIssueTypes());
    }

    public RemotePriority[] getPriorities(User user) throws RemotePermissionException {
        this.confirmUserHasABrowseProjectPermission(user);
        return SoapUtils.getPriorities(this.constantsManager.getPriorities());
    }

    public RemoteStatus[] getStatuses(User user) throws RemotePermissionException {
        this.confirmUserHasABrowseProjectPermission(user);
        return SoapUtils.getStatuses(this.constantsManager.getStatuses());
    }

    public RemoteResolution[] getResolutions(User user) throws RemotePermissionException {
        this.confirmUserHasABrowseProjectPermission(user);
        return SoapUtils.getResolutions(this.constantsManager.getResolutions());
    }

    private void confirmUserHasABrowseProjectPermission(User user) throws RemotePermissionException {
        try {
            if (!this.permissionManager.hasProjects(10, user)) {
                throw new RemotePermissionException("The user " + user.getName() + " does not have the Browse Project permission for any project in JIRA");
            }
        }
        catch (Exception e) {
            throw new RemotePermissionException(e.getMessage());
        }
    }

    private void confirmUserHasBrowseProjectPermission(User user, Project project) throws RemotePermissionException {
        try {
            if (!this.permissionManager.hasPermission(10, project, user)) {
                throw new RemotePermissionException("The user '" + (user == null ? "null" : user.getName()) + "' does not have the Browse Project permission for project '" + (project == null ? "null" : project.getName()) + "'");
            }
        }
        catch (Exception e) {
            throw new RemotePermissionException(e.getMessage());
        }
    }
}

