/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.auth;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.rpc.auth.TokenManager;
import com.atlassian.jira.rpc.auth.TokenMap;
import com.atlassian.jira.rpc.exception.RemoteAuthenticationException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TokenManagerImpl
implements TokenManager {
    public static long DEFAULT_TIMEOUT = 30L * DateUtils.MINUTE_MILLIS;
    private static final Logger log = Logger.getLogger(TokenManagerImpl.class);
    private final Map<String, String> userTokens;
    private PermissionManager permissionManager;
    private final LoginService loginService;
    private final JiraAuthenticationContext authenticationContext;
    private final UserManager userManager;
    private static final String TRUSTED_APPS_TOKEN = "trustedappstoken";

    public TokenManagerImpl(PermissionManager permissionManager, LoginService loginService, JiraAuthenticationContext authenticationContext, UserManager userManager) {
        this(DEFAULT_TIMEOUT, permissionManager, loginService, authenticationContext, userManager);
    }

    TokenManagerImpl(long timeout, PermissionManager permissionManager, LoginService loginService, JiraAuthenticationContext authenticationContext, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.loginService = loginService;
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.userTokens = new TokenMap<String, String>(timeout);
    }

    public String login(String username, String password) throws RemoteException {
        if (this.authenticationContext.getLoggedInUser() != null) {
            log.debug((Object)("User '" + this.authenticationContext.getLoggedInUser().getName() + "' already authenticated, not attempting authentication."));
            return TRUSTED_APPS_TOKEN;
        }
        User user = this.userManager.getUserObject(username);
        if (user != null) {
            LoginResult loginResult = this.loginService.authenticate(user, password);
            if (loginResult.getReason() == LoginReason.AUTHENTICATION_DENIED) {
                throw new RemoteAuthenticationException("Attempt to log in user '" + username + "' failed. The maximum number of failed login attempts has been reached. Please log into the application through the web interface to reset the number of failed login attempts.");
            }
            if (loginResult.isOK()) {
                return this.createToken(user);
            }
        }
        throw new RemoteAuthenticationException("Invalid username or password.");
    }

    public boolean logout(String token) {
        return token == null || this.userTokens.remove(token) != null;
    }

    private String createToken(User user) throws RemoteException {
        int count = 0;
        String token = RandomGenerator.randomString((int)10);
        while (this.userTokens.containsKey(token) && count++ < 10) {
            token = RandomGenerator.randomString((int)10);
        }
        if (count >= 10) {
            throw new RemoteException("Error generating authentication token after 10 attempts?");
        }
        this.userTokens.put(token, user.getName());
        return token;
    }

    public User retrieveUser(String token) throws RemoteAuthenticationException, RemotePermissionException {
        User user = this.getUserFromToken(token);
        if (!this.permissionManager.hasPermission(1, user)) {
            throw new RemotePermissionException("No permission to perform operation.");
        }
        return user;
    }

    public User retrieveUserNoPermissionCheck(String token) throws RemoteAuthenticationException, RemotePermissionException {
        if (StringUtils.isBlank((String)token)) {
            return null;
        }
        return this.getUserFromToken(token);
    }

    private User getUserFromToken(String token) throws RemoteAuthenticationException {
        User user = this.authenticationContext.getLoggedInUser();
        if (user != null) {
            log.debug((Object)("Ignoring token '" + token + "' because user '" + user.getName() + "' is already in the AuthenticationContext."));
            return user;
        }
        String userName = this.userTokens.get(token);
        if (StringUtils.isNotBlank((String)userName)) {
            user = this.userManager.getUserObject(userName);
        }
        if (user == null) {
            throw new RemoteAuthenticationException("User not authenticated yet, or session timed out.");
        }
        return user;
    }
}

