/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPathFilterCHGPContainer;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class TransformXPathFilterCHGP
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    static final Integer STATE_INCLUDE = new Integer(0);
    static final Integer STATE_EXCLUDE_BUT_SEARCH = new Integer(1);
    static final Integer STATE_EXCLUDE = new Integer(2);
    Integer state = STATE_EXCLUDE_BUT_SEARCH;
    Stack stateStack = new Stack();
    Set inputSet;
    Set includeSearchSet;
    Set excludeSearchSet;
    Set excludeSet;
    Set resultSet;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            Document document;
            Element element;
            this.inputSet = xMLSignatureInput.getNodeSet();
            CachedXPathFuncHereAPI cachedXPathFuncHereAPI = new CachedXPathFuncHereAPI(xMLSignatureInput.getCachedXPathAPI());
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI(xMLSignatureInput.getCachedXPathAPI());
            if (this.inputSet.size() == 0) {
                Object[] objectArray = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("empty", objectArray);
            }
            Element element2 = this._transformObject.getElement();
            Element element3 = (Element)cachedXPathAPI.selectSingleNode((Node)element2, "./dsig-xpathalt:XPathAlternative", (Node)(element = XMLUtils.createDSctx(document = element2.getOwnerDocument(), "dsig-xpathalt", implementedTransformURI)));
            if (element3 == null) {
                Object[] objectArray = new Object[]{"{http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter}XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            XPathFilterCHGPContainer xPathFilterCHGPContainer = XPathFilterCHGPContainer.getInstance(element3, xMLSignatureInput.getSourceURI());
            Document document2 = null;
            Iterator iterator = this.inputSet.iterator();
            if (iterator.hasNext()) {
                document2 = XMLUtils.getOwnerDocument((Node)iterator.next());
            }
            iterator = xPathFilterCHGPContainer.getHereContextNodeIncludeButSearch();
            Object object = null;
            if (iterator != null) {
                object = cachedXPathFuncHereAPI.selectNodeList(document, (Node)((Object)iterator), xPathFilterCHGPContainer.getElement());
            }
            this.includeSearchSet = TransformXPathFilterCHGP.nodeListToSet(object);
            iterator = xPathFilterCHGPContainer.getHereContextNodeExcludeButSearch();
            object = null;
            if (iterator != null) {
                object = cachedXPathFuncHereAPI.selectNodeList(document, (Node)((Object)iterator), xPathFilterCHGPContainer.getElement());
            }
            this.excludeSearchSet = TransformXPathFilterCHGP.nodeListToSet((NodeList)object);
            iterator = xPathFilterCHGPContainer.getHereContextNodeExclude();
            object = null;
            if (iterator != null) {
                object = cachedXPathFuncHereAPI.selectNodeList(document, (Node)((Object)iterator), xPathFilterCHGPContainer.getElement());
            }
            this.excludeSet = TransformXPathFilterCHGP.nodeListToSet((NodeList)object);
            if (xPathFilterCHGPContainer.getIncludeSlashPolicy()) {
                this.includeSearchSet.add(document2);
            } else {
                this.excludeSearchSet.add(document2);
            }
            this.resultSet = new HashSet();
            iterator = (DocumentTraversal)((Object)document2);
            object = document2;
            AlwaysAcceptNodeFilter alwaysAcceptNodeFilter = new AlwaysAcceptNodeFilter();
            TreeWalker treeWalker = iterator.createTreeWalker((Node)object, -1, alwaysAcceptNodeFilter, true);
            this.process(treeWalker);
            iterator = new XMLSignatureInput(this.resultSet, xMLSignatureInput.getCachedXPathAPI());
            ((XMLSignatureInput)((Object)iterator)).setSourceURI(xMLSignatureInput.getSourceURI());
            return iterator;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
    }

    private void process(TreeWalker treeWalker) {
        Object object;
        Node node = treeWalker.getCurrentNode();
        if (this.excludeSet.contains(node)) {
            treeWalker.setCurrentNode(node);
            return;
        }
        if (this.includeSearchSet.contains(node)) {
            this.state = STATE_INCLUDE;
        } else if (this.excludeSearchSet.contains(node)) {
            this.state = STATE_EXCLUDE_BUT_SEARCH;
        }
        if (this.inputSet.contains(node) && this.state == STATE_INCLUDE) {
            this.resultSet.add(node);
            if (node.getNodeType() == 1) {
                object = ((Element)node).getAttributes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node2 = object.item(i);
                    if (!this.inputSet.contains(node2) || this.excludeSearchSet.contains(node2) || this.excludeSet.contains(node2)) continue;
                    this.resultSet.add(node2);
                }
            }
        }
        object = treeWalker.firstChild();
        while (object != null) {
            this.stateStack.push(this.state);
            this.process(treeWalker);
            this.state = (Integer)this.stateStack.pop();
            object = treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(node);
    }

    private static Set nodeListToSet(NodeList nodeList) {
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = nodeList == null ? 0 : nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public class AlwaysAcceptNodeFilter
    implements NodeFilter {
        public short acceptNode(Node node) {
            return 1;
        }
    }
}

