/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.parser;

import com.opensymphony.module.sitemesh.parser.AbstractPage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class SuperFastPage
extends AbstractPage {
    private final int bodyStart;
    private final int bodyLength;
    private final int pageLength;

    public SuperFastPage(char[] pageData, int pageLength, int bodyStart, int bodyLength) {
        this.pageLength = pageLength;
        this.bodyStart = bodyStart;
        this.bodyLength = bodyLength;
        this.pageData = pageData;
    }

    public void writePage(Writer out) throws IOException {
        out.write(this.pageData, 0, this.pageLength);
    }

    public int getContentLength() {
        CountingOutputStream counter = new CountingOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(counter);
            this.writePage(writer);
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return counter.getCount();
    }

    public void writeBody(Writer out) throws IOException {
        out.write(this.pageData, this.bodyStart, this.bodyLength);
    }

    protected static class CountingOutputStream
    extends OutputStream {
        private int count = 0;

        protected CountingOutputStream() {
        }

        public void write(int i) throws IOException {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

