/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.db;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.BootstrapException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DatabaseHelper {
    private static final Logger log = Logger.getLogger(DatabaseHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabaseLowerProperty(Properties databaseProperties, ApplicationConfiguration applicationConfig) throws BootstrapException {
        Connection conn = null;
        try {
            if (this.isDirectConnection(databaseProperties)) {
                String driverClassName = databaseProperties.getProperty("hibernate.connection.driver_class");
                String databaseUrl = databaseProperties.getProperty("hibernate.connection.url");
                String userName = databaseProperties.getProperty("hibernate.connection.username");
                String password = databaseProperties.getProperty("hibernate.connection.password");
                if (driverClassName != null) {
                    Class.forName(driverClassName);
                }
                conn = DriverManager.getConnection(databaseUrl, userName, password);
            } else {
                conn = this.getDatasource(databaseProperties.getProperty("hibernate.connection.datasource")).getConnection();
            }
            Statement st = conn.createStatement();
            String sqlQuery = "select lower('\u00dcbersicht')";
            ResultSet rs = st.executeQuery(sqlQuery);
            rs.next();
            if (rs.getString(1).equals("\u00dcbersicht")) {
                applicationConfig.setProperty((Object)"hibernate.database.lower_non_ascii_supported", Boolean.FALSE);
            } else {
                applicationConfig.setProperty((Object)"hibernate.database.lower_non_ascii_supported", Boolean.TRUE);
            }
            applicationConfig.save();
        }
        catch (SQLException e) {
            log.info((Object)("SQL query could not be excecuted: " + e), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Configuration file could not be saved: ", (Throwable)e);
        }
        finally {
            try {
                if (conn == null) {
                    log.error((Object)"Connection was null. We could not successfully connect to the specified database!");
                } else {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.fatal((Object)("Could not close database connection opened for first test! Exception: " + e));
            }
        }
    }

    public DataSource getDatasource(String ds) throws BootstrapException {
        DataSource dsrc = null;
        log.debug((Object)("datasource is " + ds));
        try {
            InitialContext ctx = new InitialContext();
            dsrc = (DataSource)ctx.lookup(ds);
            if (dsrc == null) {
                throw new NamingException("Could not locate " + ds);
            }
        }
        catch (NamingException e) {
            log.error((Object)("Could not locate datasource: " + ds), (Throwable)e);
            throw new BootstrapException("Could not locate datasource: " + ds, e);
        }
        catch (ClassCastException e) {
            log.error((Object)("Couldn't locate Datasource (" + ds + ") in the initial context. An object was bound to this name but whatever we found, it wasn't a Datasource: " + e));
            throw new BootstrapException("Couldn't locate Datasource (" + ds + ") in the initial context. An object was bound to this name but whatever we found, it wasn't a Datasource: ", e);
        }
        return dsrc;
    }

    private boolean isDirectConnection(Properties databaseProperties) {
        return databaseProperties.getProperty("hibernate.connection.datasource") == null;
    }
}

