/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net.auth;

import com.atlassian.sal.core.net.auth.HttpClientAuthenticator;
import com.atlassian.sal.core.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class TrustedTokenAuthenticator
implements HttpClientAuthenticator {
    private final EncryptedCertificate userCertificate;

    public TrustedTokenAuthenticator(String username, CertificateFactory certificateFactory) {
        this.userCertificate = username != null && !username.equals("") ? certificateFactory.createCertificate(username) : null;
    }

    public void process(HttpClient httpClient, HttpMethod method) {
        if (this.userCertificate != null && this.userCertificate.getID() != null && !"".equals(this.userCertificate.getID().trim())) {
            method.setRequestHeader("X-Seraph-Trusted-App-ID", this.userCertificate.getID());
            method.setRequestHeader("X-Seraph-Trusted-App-Key", this.userCertificate.getSecretKey());
            method.setRequestHeader("X-Seraph-Trusted-App-Cert", this.userCertificate.getCertificate());
        }
    }
}

