/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.core.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalDelegateExecutorService
extends AbstractExecutorService {
    protected final ThreadLocalContextManager manager;
    private final ExecutorService delegate;

    public ThreadLocalDelegateExecutorService(ThreadLocalContextManager manager, ExecutorService delegate) {
        this.manager = manager;
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new ThreadLocalDelegateRunnable(this.manager, command));
    }
}

