/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.event.application.ApplicationRemoteAddressAddedEvent;
import com.atlassian.crowd.event.application.ApplicationRemoteAddressRemovedEvent;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.UpgradeablePasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManagerGeneric
implements ApplicationManager {
    private final ApplicationDAO applicationDao;
    private final PasswordEncoderFactory passwordEncoderFactory;
    private final EventPublisher eventPublisher;

    public ApplicationManagerGeneric(ApplicationDAO applicationDao, PasswordEncoderFactory passwordEncoderFactory, EventPublisher eventPublisher) {
        this.applicationDao = applicationDao;
        this.passwordEncoderFactory = passwordEncoderFactory;
        this.eventPublisher = eventPublisher;
    }

    public Application add(Application application) throws InvalidCredentialException {
        Validate.notNull((Object)application, (String)"application should not be null");
        if (application.getCredential() == null) {
            throw new InvalidCredentialException("Password of the application cannot be null");
        }
        PasswordCredential encryptedCredential = this.encryptAndUpdateApplicationCredential(application.getCredential());
        return this.applicationDao.add(application, encryptedCredential);
    }

    public Application findById(long id) throws ApplicationNotFoundException {
        return this.applicationDao.findById(id);
    }

    public Application findByName(String name) throws ApplicationNotFoundException {
        return this.applicationDao.findByName(name);
    }

    public void remove(Application application) throws ApplicationManagerException {
        if (application.isPermanent()) {
            throw new ApplicationManagerException("Cannot delete a permanent application");
        }
        this.applicationDao.remove(application);
    }

    public void removeDirectoryFromApplication(Directory directory, Application application) throws ApplicationManagerException {
        DirectoryMapping mapping = application.getDirectoryMapping(directory.getId().longValue());
        if (mapping != null) {
            try {
                this.applicationDao.removeDirectoryMapping(application.getId().longValue(), directory.getId().longValue());
            }
            catch (ApplicationNotFoundException e) {
                // empty catch block
            }
        }
    }

    public List<Application> search(EntityQuery query) {
        return this.applicationDao.search(query);
    }

    public List<Application> findAll() {
        return this.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1));
    }

    public Application update(Application application) throws ApplicationManagerException, ApplicationNotFoundException {
        Application currentApplication;
        if (application.getType() == ApplicationType.CROWD && !application.isActive()) {
            throw new ApplicationManagerException("Cannot deactivate the Crowd application");
        }
        if (application.isPermanent()) {
            try {
                Application savedApp = this.findById(application.getId());
                if (!savedApp.getName().equals(application.getName())) {
                    throw new ApplicationManagerException("Cannot rename a permanent application");
                }
            }
            catch (ApplicationNotFoundException e) {
                throw new ApplicationManagerException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            currentApplication = this.findByName(application.getName());
        }
        catch (ApplicationNotFoundException e) {
            currentApplication = this.findById(application.getId());
        }
        if (application.getId().equals(currentApplication.getId())) {
            return this.applicationDao.update(application);
        }
        throw new ApplicationManagerException("You potentially tried to update an application with a different ID than the one you passed in");
    }

    public void updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationManagerException, ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)passwordCredential);
        Validate.notNull((Object)passwordCredential.getCredential());
        PasswordCredential encryptedCredential = this.encryptAndUpdateApplicationCredential(passwordCredential);
        this.applicationDao.updateCredential(application, encryptedCredential);
    }

    public boolean authenticate(Application application, PasswordCredential testCredential) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)testCredential);
        Validate.notNull((Object)testCredential.getCredential());
        PasswordEncoder encoder = this.getAtlassianSecurityEncoder();
        if (!encoder.isPasswordValid(application.getCredential().getCredential(), testCredential.getCredential(), null)) {
            return false;
        }
        this.upgradePasswordIfRequired(application, encoder, testCredential.getCredential());
        return true;
    }

    private void upgradePasswordIfRequired(Application application, PasswordEncoder encoder, String rawPass) throws ApplicationNotFoundException {
        UpgradeablePasswordEncoder upgradeableEncoder;
        if (encoder instanceof UpgradeablePasswordEncoder && (upgradeableEncoder = (UpgradeablePasswordEncoder)encoder).isUpgradeRequired(application.getCredential().getCredential())) {
            String newEncPass = encoder.encodePassword(rawPass, null);
            this.applicationDao.updateCredential(application, new PasswordCredential(newEncPass, true));
        }
    }

    public void addDirectoryMapping(Application application, Directory directory, boolean allowAllToAuthenticate, OperationType ... operationTypes) throws ApplicationNotFoundException, DirectoryNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.addDirectoryMapping(application.getId().longValue(), directory.getId().longValue(), allowAllToAuthenticate, operationTypes);
    }

    public void updateDirectoryMapping(Application application, Directory directory, int position) throws ApplicationNotFoundException, DirectoryNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.updateDirectoryMapping(application.getId().longValue(), directory.getId().longValue(), position);
    }

    public void updateDirectoryMapping(Application application, Directory directory, boolean allowAllToAuthenticate) throws ApplicationNotFoundException, DirectoryNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.updateDirectoryMapping(application.getId().longValue(), directory.getId().longValue(), allowAllToAuthenticate);
    }

    public void updateDirectoryMapping(Application application, Directory directory, boolean allowAllToAuthenticate, Set<OperationType> operationTypes) throws ApplicationNotFoundException, DirectoryNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.updateDirectoryMapping(application.getId().longValue(), directory.getId().longValue(), allowAllToAuthenticate, operationTypes);
    }

    public void addRemoteAddress(Application application, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        this.applicationDao.addRemoteAddress(application.getId().longValue(), remoteAddress);
        this.eventPublisher.publish((Object)new ApplicationRemoteAddressAddedEvent(application, remoteAddress));
    }

    public void removeRemoteAddress(Application application, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)remoteAddress);
        this.applicationDao.removeRemoteAddress(application.getId().longValue(), remoteAddress);
        this.eventPublisher.publish((Object)new ApplicationRemoteAddressRemovedEvent(application, remoteAddress));
    }

    public void addGroupMapping(Application application, Directory directory, String groupName) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.addGroupMapping(application.getId().longValue(), directory.getId().longValue(), groupName);
    }

    public void removeGroupMapping(Application application, Directory directory, String groupName) {
        Validate.notNull((Object)application);
        Validate.notNull((Object)application.getId());
        Validate.notNull((Object)directory);
        Validate.notNull((Object)directory.getId());
        this.applicationDao.removeGroupMapping(application.getId().longValue(), directory.getId().longValue(), groupName);
    }

    private PasswordCredential encryptAndUpdateApplicationCredential(PasswordCredential passwordCredential) {
        PasswordEncoder encoder = this.getAtlassianSecurityEncoder();
        String encryptedPassword = encoder.encodePassword(passwordCredential.getCredential(), null);
        passwordCredential.setCredential(encryptedPassword);
        passwordCredential.setEncryptedCredential(true);
        return passwordCredential;
    }

    private PasswordEncoder getAtlassianSecurityEncoder() {
        return this.passwordEncoderFactory.getEncoder("atlassian-security");
    }
}

