/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.core.event.listener;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.EntityComparator;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoGroupAdderListener {
    protected static final String AUTO_GROUPS_ADDED = "autoGroupsAdded";
    private final Logger logger = Logger.getLogger(this.getClass());
    private DirectoryInstanceLoader directoryInstanceLoader;

    @EventListener
    public void handleEvent(UserAuthenticatedEvent event) {
        Directory directory = event.getDirectory();
        String concatenatedGroupNames = directory.getValue("autoAddGroups");
        if (StringUtils.isNotBlank((String)concatenatedGroupNames) && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) {
            String[] groups = StringUtils.split((String)concatenatedGroupNames, (char)'|');
            User user = event.getUser();
            try {
                RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
                UserWithAttributes userWithAttributes = remoteDirectory.findUserWithAttributesByName(user.getName());
                if (Boolean.parseBoolean(userWithAttributes.getValue(AUTO_GROUPS_ADDED))) {
                    return;
                }
                TreeSet<String> currentMemberships = new TreeSet<String>(EntityComparator.of(String.class));
                currentMemberships.addAll(this.searchDirectGroupMemberships(remoteDirectory, user));
                for (String groupName : groups) {
                    try {
                        if (currentMemberships.contains(groupName)) continue;
                        remoteDirectory.addUserToGroup(user.getName(), groupName);
                    }
                    catch (GroupNotFoundException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                    catch (OperationFailedException e) {
                        this.logger.error((Object)("Could not access directory: " + e.getMessage()), (Throwable)e);
                    }
                    catch (UserNotFoundException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                }
                remoteDirectory.storeUserAttributes(user.getName(), (Map)ImmutableMap.of((Object)AUTO_GROUPS_ADDED, Collections.singleton(Boolean.TRUE.toString())));
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)("Could not instantiate directory: " + e.getMessage()), (Throwable)e);
            }
            catch (OperationFailedException e) {
                this.logger.error((Object)("Could not access directory: " + e.getMessage()), (Throwable)e);
            }
            catch (UserNotFoundException e) {
                this.logger.error((Object)("Could not access user: " + e.getMessage()), (Throwable)e);
            }
        } else if (StringUtils.isNotBlank((String)concatenatedGroupNames)) {
            this.logger.error((Object)("You have groups <" + concatenatedGroupNames + "> to be auto-added for the user <" + event.getUser().getName() + ">, but the directory does not have permission for Group updates."));
        }
    }

    private List<String> searchDirectGroupMemberships(RemoteDirectory remoteDirectory, User user) throws OperationFailedException {
        return remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1));
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }
}

