/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.util.PasswordHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class InternalDirectoryUtilsImpl
implements InternalDirectoryUtils {
    private final PasswordHelper passwordHelper;

    public InternalDirectoryUtilsImpl(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }

    public void validateDirectoryForEntity(DirectoryEntity entity, Long directoryId) {
        Validate.notNull((Object)entity, (String)"entity cannot be null");
        Validate.notNull((Object)entity.getDirectoryId(), (String)"directoryId of entity cannot be null");
        Validate.isTrue((entity.getDirectoryId() == directoryId.longValue() ? 1 : 0) != 0, (String)"directoryId does not match the directoryId of the InternalDirectory");
    }

    public void validateUsername(String username) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("A username must not be null or empty or blank");
        }
    }

    public void validateCredential(PasswordCredential credential, String regex) throws InvalidCredentialException {
        if (credential == null || StringUtils.isBlank((String)credential.getCredential())) {
            throw new InvalidCredentialException("You cannot have an empty password");
        }
        if (StringUtils.isNotBlank((String)regex) && !this.passwordHelper.validateRegex(regex, credential)) {
            throw new InvalidCredentialException("Your new password does not meet the directory complexity requirements");
        }
    }

    public void validateGroupName(Group group, String groupName) {
        if (StringUtils.isBlank((String)groupName)) {
            throw new IllegalArgumentException("A group name must not be null or empty or blank");
        }
    }
}

