/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.filter;

import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugin.servlet.filter.IteratingFilterChain;
import com.atlassian.plugin.servlet.util.ServletContextServletModuleManagerAccessor;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFilterModuleContainerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServletFilterModuleContainerFilter.class);
    private FilterConfig filterConfig;
    private FilterLocation location;
    private FilterDispatcherCondition condition;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.location = FilterLocation.parse(filterConfig.getInitParameter("location"));
        String dispatcherCondition = filterConfig.getInitParameter("dispatcher");
        if (StringUtils.isNotBlank((String)dispatcherCondition)) {
            if (!FilterDispatcherCondition.contains(dispatcherCondition)) {
                throw new ServletException("The dispatcher value must be one of the following only " + Arrays.asList(FilterDispatcherCondition.values()) + " - '" + (Object)((Object)this.condition) + "' is not a valid value.");
            }
        } else {
            throw new ServletException("The dispatcher init param must be specified and be one of " + Arrays.asList(FilterDispatcherCondition.values()));
        }
        this.condition = FilterDispatcherCondition.valueOf(dispatcherCondition);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.getServletModuleManager() == null) {
            log.info("Could not get ServletModuleManager. Skipping filter plugins.");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Iterable<Filter> filters = this.getServletModuleManager().getFilters(this.location, ServletFilterModuleContainerFilter.getUri(request), this.filterConfig, this.condition);
        IteratingFilterChain pluginFilterChain = new IteratingFilterChain(filters.iterator(), chain);
        pluginFilterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected ServletModuleManager getServletModuleManager() {
        return ServletContextServletModuleManagerAccessor.getServletModuleManager(this.filterConfig.getServletContext());
    }

    protected final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final FilterLocation getFilterLocation() {
        return this.location;
    }

    private static String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = ServletFilterModuleContainerFilter.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    private static String getServletPath(HttpServletRequest request) {
        int endIndex;
        int pos;
        String servletPath = request.getServletPath();
        String requestUri = request.getRequestURI();
        if (requestUri != null && servletPath != null && !requestUri.endsWith(servletPath) && (pos = requestUri.indexOf(servletPath)) > -1) {
            servletPath = requestUri.substring(requestUri.indexOf(servletPath));
        }
        if (null != servletPath && !"".equals(servletPath)) {
            return servletPath;
        }
        int startIndex = request.getContextPath().equals("") ? 0 : request.getContextPath().length();
        int n = endIndex = request.getPathInfo() == null ? requestUri.length() : requestUri.lastIndexOf(request.getPathInfo());
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        return requestUri.substring(startIndex, endIndex);
    }
}

