/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.CertificateTooOldException;
import com.atlassian.security.auth.trustedapps.DefaultRequestValidator;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.InvalidRequestException;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.RequestValidator;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import java.math.BigInteger;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;

public class DefaultTrustedApplication
implements TrustedApplication {
    private final String name;
    protected final String id;
    protected final PublicKey publicKey;
    protected final RequestConditions requestConditions;
    protected final RequestValidator requestValidator;
    protected final EncryptionProvider encryptionProvider;

    static ApplicationCertificate checkCertificateExpiry(ApplicationCertificate certificate, long certificateTimeout) throws InvalidCertificateException {
        if (certificateTimeout != 0L) {
            BigInteger created = BigInteger.valueOf(certificate.getCreationTime().getTime());
            BigInteger ttl = BigInteger.valueOf(certificateTimeout);
            BigInteger now = BigInteger.valueOf(System.currentTimeMillis());
            if (created.add(ttl).compareTo(now) < 0) {
                throw new CertificateTooOldException(certificate, certificateTimeout);
            }
        }
        return certificate;
    }

    public DefaultTrustedApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, String id, String name, RequestConditions requestConditions) {
        Null.not("encryptionProvider", encryptionProvider);
        Null.not("publicKey", publicKey);
        Null.not("id", id);
        Null.not("requestConditions", requestConditions);
        this.encryptionProvider = encryptionProvider;
        this.publicKey = publicKey;
        this.id = id;
        this.name = name;
        this.requestConditions = requestConditions;
        this.requestValidator = new DefaultRequestValidator(requestConditions.getIPMatcher(), requestConditions.getURLMatcher());
    }

    public DefaultTrustedApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, String id, RequestConditions requestConditions) {
        this(encryptionProvider, publicKey, id, null, requestConditions);
    }

    public DefaultTrustedApplication(PublicKey publicKey, String id, RequestConditions requestConditions) {
        this(new BouncyCastleEncryptionProvider(), publicKey, id, null, requestConditions);
    }

    public DefaultTrustedApplication(PublicKey publicKey, String id, String name, RequestConditions requestConditions) {
        this(new BouncyCastleEncryptionProvider(), publicKey, id, name, requestConditions);
    }

    public ApplicationCertificate decode(EncryptedCertificate encCert, HttpServletRequest request) throws InvalidCertificateException {
        ApplicationCertificate certificate = this.encryptionProvider.decodeEncryptedCertificate(encCert, this.publicKey, this.getID());
        DefaultTrustedApplication.checkCertificateExpiry(certificate, this.requestConditions.getCertificateTimeout());
        this.checkRequest(request);
        return certificate;
    }

    public RequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    protected void checkRequest(HttpServletRequest request) throws InvalidCertificateException {
        try {
            this.requestValidator.validate(request);
        }
        catch (InvalidRequestException e) {
            throw new InvalidCertificateException(e);
        }
    }
}

