/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.util.ClassLoaderUtils;
import webwork.util.InjectionUtils;
import webwork.util.injection.ObjectFactory;

public final class WebWorkUtil {
    private Context ctx;
    ConcurrentMap<String, Class> classesMap = new ConcurrentHashMap<String, Class>();

    public WebWorkUtil(Context ctx) {
        this.ctx = ctx;
    }

    public Action action(Object aName) throws Exception {
        return ActionFactory.getAction(aName.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Action anAction) throws Exception {
        long start = System.currentTimeMillis();
        try {
            String string = anAction.execute();
            return string;
        }
        finally {
            LogFactory.getLog(this.getClass()).debug((Object)("Execute:" + (System.currentTimeMillis() - start)));
        }
    }

    public Object bean(Object aName) throws Exception {
        String name = aName.toString();
        Class c = (Class)this.classesMap.get(name);
        if (c == null) {
            c = ClassLoaderUtils.loadClass(name, WebWorkUtil.class);
            this.classesMap.put(name, c);
        }
        return ObjectFactory.instantiate(c);
    }

    public String include(Object aName, ServletRequest aRequest, ServletResponse aResponse) throws Exception {
        try {
            RequestDispatcher dispatcher = aRequest.getRequestDispatcher(aName.toString());
            if (dispatcher == null) {
                throw new IllegalArgumentException("Cannot find included file " + aName);
            }
            ServletResponseHandler responseHandler = new ServletResponseHandler(aResponse);
            Class[] interfaces = new Class[]{HttpServletResponse.class};
            HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)responseHandler);
            dispatcher.include(aRequest, (ServletResponse)response);
            return responseHandler.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public long toLong(int anInt) {
        return anInt;
    }

    public long toLong(String aLong) {
        return Long.parseLong(aLong);
    }

    public int toInt(long aLong) {
        return (int)aLong;
    }

    public String toString(long aLong) {
        return Long.toString(aLong);
    }

    public String toString(int anInt) {
        return Integer.toString(anInt);
    }

    public String evaluate(String expression) throws IOException, ResourceNotFoundException, MethodInvocationException, ParseErrorException {
        CharArrayWriter writer = new CharArrayWriter();
        Velocity.evaluate((Context)this.ctx, (Writer)writer, (String)("Error parsing " + expression), (String)expression);
        return writer.toString();
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        Writer writer;

        ServletOutputStreamWrapper(Writer aWriter) {
            this.writer = aWriter;
        }

        public void write(int aByte) {
            try {
                this.writer.write(aByte);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class ServletResponseHandler
    implements InvocationHandler {
        ServletResponse response;
        StringWriter strout;
        PrintWriter writer;
        ServletOutputStream sout;

        ServletResponseHandler(ServletResponse aResponse) {
            this.response = aResponse;
            this.strout = new StringWriter();
            this.sout = new ServletOutputStreamWrapper(this.strout);
            this.writer = new PrintWriter(this.strout);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getOutputStream")) {
                return this.getOutputStream();
            }
            if (method.getName().equals("getWriter")) {
                return this.writer;
            }
            return InjectionUtils.invoke(method, this.response, args);
        }

        ServletOutputStream getOutputStream() {
            return this.sout;
        }

        public String getData() {
            this.writer.flush();
            return this.strout.toString();
        }
    }
}

