/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.vui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.util.ClassLoaderUtils;

public final class BrowserSupport {
    static Log log = LogFactory.getLog(BrowserSupport.class);
    static Properties properties;
    static Map browserMap;
    static List browserMatch;

    public static void addBrowserMatch(String uaString, String templateDir) {
        int w = uaString.indexOf("*");
        Match m = new Match();
        m.userAgent = uaString;
        m.match = w > 0 ? uaString.substring(0, w) : null;
        m.templateDirectory = templateDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading useragent match: " + m.match + " [" + uaString + "] directory: " + templateDir));
        }
        browserMatch.add(m);
    }

    public static void loadBrowserInfo(Properties p) {
        properties = p;
        String browsers = p.getProperty("browsers");
        if (browsers != null) {
            StringTokenizer tok = new StringTokenizer(browsers, ",");
            while (tok.hasMoreTokens()) {
                String template;
                String token = tok.nextToken();
                String ua = p.getProperty(token + ".useragent");
                if (ua == null || (template = p.getProperty(token + ".templatedirectory")) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading useragent: " + token + " [" + ua + "] directory: " + template));
                }
                browserMap.put(ua, template);
                if (ua.indexOf("*") <= -1) continue;
                BrowserSupport.addBrowserMatch(ua, template);
            }
        }
    }

    public static String getTemplateDirectoryFromMatch(String userAgent) {
        Iterator i = browserMatch.iterator();
        Match dm = null;
        while (i.hasNext()) {
            Match m = (Match)i.next();
            if (m.match == null) {
                dm = m;
                continue;
            }
            if (!userAgent.startsWith(m.match)) continue;
            return m.templateDirectory;
        }
        return dm == null ? null : dm.templateDirectory;
    }

    public static String getBrowserTemplateDirectory(String userAgent) {
        String tempDir = (String)browserMap.get(userAgent);
        if (tempDir != null || (tempDir = BrowserSupport.getTemplateDirectoryFromMatch(userAgent)) == null) {
            // empty if block
        }
        return tempDir == null ? "/template/vxml/" : tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        browserMap = Collections.synchronizedMap(new HashMap(2));
        browserMatch = Collections.synchronizedList(new ArrayList(2));
        InputStream in = null;
        Properties p = new Properties();
        try {
            in = ClassLoaderUtils.getResourceAsStream("/vxml.properties", BrowserSupport.class);
            if (in != null) {
                p.load(in);
                BrowserSupport.loadBrowserInfo(p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                in = null;
            }
        }
    }

    static final class Match {
        String match;
        String userAgent;
        String templateDirectory;

        Match() {
        }
    }
}

