/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.http;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.http.Proxy;

public class SessionTag
extends TagSupport {
    private String _host;
    private String _port;
    private Proxy _proxy = new Proxy();
    private boolean _secure;
    private String _userAgent;
    private boolean _strictMode = false;
    private HttpClient _httpClient;

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        if (this.isProxyAvailable()) {
            this._httpClient = new HttpClient();
            this._httpClient.getHostConfiguration().setProxy(this.getProxyHost(), this.getProxyPort());
        } else {
            this._httpClient = new HttpClient();
        }
        this.invokeBody(xmlOutput);
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public boolean isProxyAvailable() {
        return this.getProxy() != null && this.getProxy().getHost() != null && this.getProxy().getPort() != -1;
    }

    public String getProxyHost() {
        return this.getProxy().getHost();
    }

    public void setProxyHost(String host) {
        this.getProxy().setHost(host);
    }

    public int getProxyPort() {
        return this.getProxy().getPort();
    }

    public void setProxyPort(int port) {
        this.getProxy().setPort(port);
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public Proxy getProxy() {
        return this._proxy;
    }

    public void setProxy(Proxy proxy) {
        this._proxy = proxy;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    public boolean isStrictMode() {
        return this._strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this._strictMode = strictMode;
    }
}

