/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.http.SessionTag;

public abstract class HttpTagSupport
extends TagSupport {
    private String _var;
    private String _path;
    private String _uri;
    private boolean _followRedirects = false;
    private List _parameters;
    private List _requestHeaders;
    private static final String HEADER_NAME_USER_AGENT = "User-Agent";
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$http$SessionTag;

    public HttpTagSupport() {
        this.setParameters(new ArrayList());
        this.setRequestHeaders(new ArrayList());
    }

    public String getResolvedUrl() {
        if (this.getUri() != null) {
            return this.getUri();
        }
        SessionTag session = (SessionTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$http$SessionTag == null ? (class$org$apache$commons$jelly$tags$http$SessionTag = HttpTagSupport.class$("org.apache.commons.jelly.tags.http.SessionTag")) : class$org$apache$commons$jelly$tags$http$SessionTag);
        String host = session.getHost();
        String port = session.getPort();
        return "http://" + host + this.getPath();
    }

    protected abstract HttpMethod getHttpMethod() throws MalformedURLException;

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        this.invokeBody(xmlOutput);
        long start = System.currentTimeMillis();
        HttpMethod urlMethod = null;
        try {
            urlMethod = this.getConfiguredHttpMethod();
            this.getHttpClient().executeMethod(urlMethod);
        }
        catch (MalformedURLException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (IOException e) {
            throw new JellyTagException((Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (this.getVar() != null) {
            this.getContext().setVariable(this.getVar(), (Object)urlMethod);
            this.getContext().setVariable(this.getVar() + ".responseTime", (Object)String.valueOf(end - start));
        }
    }

    private HttpMethod getConfiguredHttpMethod() throws MalformedURLException {
        HttpMethod urlMethod = this.getHttpMethod();
        urlMethod.setFollowRedirects(this.isFollowRedirects());
        NameValuePair header = null;
        int index = 0;
        while (index < this.getRequestHeaders().size()) {
            header = (NameValuePair)this.getRequestHeaders().get(index);
            urlMethod.addRequestHeader(header.getName(), header.getValue());
            ++index;
        }
        this.setParameters(urlMethod);
        if (urlMethod.getRequestHeader(HEADER_NAME_USER_AGENT) == null && this.getSessionTag() != null && this.getSessionTag().getUserAgent() != null) {
            urlMethod.addRequestHeader(HEADER_NAME_USER_AGENT, this.getSessionTag().getUserAgent());
        }
        return urlMethod;
    }

    protected void setParameters(HttpMethod method) throws MalformedURLException {
        if (this.getParameters().size() > 0) {
            NameValuePair[] parameters = this.getParameters().toArray(new NameValuePair[0]);
            method.setQueryString(parameters);
        }
    }

    private SessionTag getSessionTag() {
        SessionTag sessionTag = (SessionTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$http$SessionTag == null ? (class$org$apache$commons$jelly$tags$http$SessionTag = HttpTagSupport.class$("org.apache.commons.jelly.tags.http.SessionTag")) : class$org$apache$commons$jelly$tags$http$SessionTag);
        return sessionTag;
    }

    private HttpClient getHttpClient() {
        SessionTag session = this.getSessionTag();
        HttpClient client = null;
        if (session != null) {
            client = session.getHttpClient();
            client.setStrictMode(session.isStrictMode());
        } else {
            client = new HttpClient();
        }
        return client;
    }

    public void addParameter(String name, String value) {
        this.getParameters().add(new NameValuePair(name, value));
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestHeaders().add(new NameValuePair(name, value));
    }

    public String getVar() {
        return this._var;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    public boolean isFollowRedirects() {
        return this._followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this._followRedirects = followRedirects;
    }

    public List getParameters() {
        return this._parameters;
    }

    public void setParameters(List parameters) {
        this._parameters = parameters;
    }

    public List getRequestHeaders() {
        return this._requestHeaders;
    }

    public void setRequestHeaders(List requestHeaders) {
        this._requestHeaders = requestHeaders;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

