/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.LogManager;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.log.PrimordialLogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.SimplePool;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.UberspectLoggable;

public class RuntimeInstance
implements RuntimeConstants,
RuntimeServices {
    private final VelocimacroFactory vmFactory = new VelocimacroFactory(this);
    private LogSystem logSystem = new PrimordialLogSystem();
    private SimplePool parserPool;
    private volatile boolean initialized;
    private ExtendedProperties overridingProperties = null;
    private final Map<String, Directive> runtimeDirectives = CopyOnWriteMap.newHashMap();
    private final ExtendedProperties configuration = new ExtendedProperties();
    private final ConfigurationCache configurationCache = new ConfigurationCache();
    private ResourceManager resourceManager = null;
    private final Introspector introspector = new Introspector(this);
    private final Map<Object, Object> applicationAttributes = new HashMap<Object, Object>();
    private Uberspect uberSpect;

    @Override
    public synchronized void init() throws Exception {
        if (!this.initialized) {
            this.info("************************************************************** ");
            this.info("Starting Jakarta Velocity v1.4-atlassian-9");
            this.info("RuntimeInstance initializing.");
            this.initializeProperties();
            this.initializeLogger();
            this.initializeResourceManager();
            this.initializeDirectives();
            this.initializeParserPool();
            this.initializeIntrospection();
            this.vmFactory.initVelocimacro();
            this.info("Velocity successfully started.");
            this.initialized = true;
        }
    }

    private void initializeIntrospection() throws Exception {
        String rm = this.getString("runtime.introspector.uberspect");
        if (rm != null && rm.length() > 0) {
            Object o = null;
            try {
                o = Class.forName(rm).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for Uberspect (" + rm + ") does not exist (or is not accessible to the current classlaoder.";
                this.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof Uberspect)) {
                String err = "The specified class for Uberspect (" + rm + ") does not implement org.apache.velocity.util.introspector.Uberspect." + " Velocity not initialized correctly.";
                this.error(err);
                throw new Exception(err);
            }
            this.uberSpect = o;
            if (this.uberSpect instanceof UberspectLoggable) {
                ((UberspectLoggable)((Object)this.uberSpect)).setRuntimeLogger(this);
            }
        } else {
            String err = "It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.";
            this.error("It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.");
            throw new Exception("It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.");
        }
    }

    private void setDefaultProperties() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/velocity.properties");
            this.configuration.load(inputStream);
            this.info("Default Properties File: " + new File("org/apache/velocity/runtime/defaults/velocity.properties").getPath());
        }
        catch (IOException ioe) {
            System.err.println("Cannot get Velocity Runtime default properties!");
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.setProperty(key, value);
    }

    @Override
    public void setConfiguration(ExtendedProperties configuration) {
        if (this.overridingProperties == null) {
            this.overridingProperties = configuration;
        } else if (this.overridingProperties != configuration) {
            this.overridingProperties.combine(configuration);
        }
    }

    @Override
    public void addProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.addProperty(key, value);
    }

    @Override
    public void clearProperty(String key) {
        if (this.overridingProperties != null) {
            this.overridingProperties.clearProperty(key);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.configurationCache.getProperty(key);
    }

    private void initializeProperties() {
        if (!this.configuration.isInitialized()) {
            this.setDefaultProperties();
        }
        if (this.overridingProperties != null) {
            this.configuration.combine(this.overridingProperties);
        }
    }

    @Override
    public void init(Properties p) throws Exception {
        this.overridingProperties = ExtendedProperties.convertProperties((Properties)p);
        this.init();
    }

    @Override
    public void init(String configurationFile) throws Exception {
        this.overridingProperties = new ExtendedProperties(configurationFile);
        this.init();
    }

    private void initializeResourceManager() throws Exception {
        Object o;
        String rm = this.getString("resource.manager.class");
        if (rm != null && rm.length() > 0) {
            o = null;
            try {
                o = Class.forName(rm).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for Resourcemanager (" + rm + ") does not exist (or is not accessible to the current classlaoder.";
                this.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof ResourceManager)) {
                String err = "The specified class for ResourceManager (" + rm + ") does not implement org.apache.runtime.resource.ResourceManager." + " Velocity not initialized correctly.";
                this.error(err);
                throw new Exception(err);
            }
        } else {
            String err = "It appears that no class was specified as the ResourceManager.  Please ensure that all configuration information is correct.";
            this.error("It appears that no class was specified as the ResourceManager.  Please ensure that all configuration information is correct.");
            throw new Exception("It appears that no class was specified as the ResourceManager.  Please ensure that all configuration information is correct.");
        }
        this.resourceManager = o;
        this.resourceManager.initialize(this);
    }

    private void initializeLogger() throws Exception {
        if (this.logSystem instanceof PrimordialLogSystem) {
            PrimordialLogSystem pls = (PrimordialLogSystem)this.logSystem;
            this.logSystem = LogManager.createLogSystem(this);
            if (this.logSystem == null) {
                this.logSystem = new NullLogSystem();
            } else {
                pls.dumpLogMessages(this.logSystem);
            }
        }
    }

    private void initializeDirectives() throws Exception {
        String[] userdirective;
        this.runtimeDirectives.clear();
        Properties directiveProperties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/directive.properties");
        if (inputStream == null) {
            throw new Exception("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
        }
        directiveProperties.load(inputStream);
        Enumeration<Object> directiveClasses = directiveProperties.elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            this.loadDirective(directiveClass, "System");
        }
        for (String element : userdirective = this.configuration.getStringArray("userdirective")) {
            this.loadDirective(element, "User");
        }
    }

    private void loadDirective(String directiveClass, String caption) {
        try {
            Object o = Class.forName(directiveClass).newInstance();
            if (o instanceof Directive) {
                Directive directive = (Directive)o;
                this.runtimeDirectives.put(directive.getName(), directive);
                this.info("Loaded " + caption + " Directive: " + directiveClass);
            } else {
                this.error(caption + " Directive " + directiveClass + " is not org.apache.velocity.runtime.directive.Directive." + " Ignoring. ");
            }
        }
        catch (Exception e) {
            this.error("Exception Loading " + caption + " Directive: " + directiveClass + " : " + e);
        }
    }

    private void initializeParserPool() {
        int numParsers = this.getInt("parser.pool.size", 20);
        this.parserPool = new SimplePool(numParsers);
        for (int i = 0; i < numParsers; ++i) {
            this.parserPool.put(this.createNewParser());
        }
        this.info("Created: " + numParsers + " parsers.");
    }

    public Parser createNewParser() {
        Parser parser = new Parser(this);
        parser.setDirectives(this.runtimeDirectives);
        return parser;
    }

    @Override
    public SimpleNode parse(Reader reader, String templateName) throws ParseException {
        return this.parse(reader, templateName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleNode parse(Reader reader, String templateName, boolean dumpNamespace) throws ParseException {
        SimpleNode ast = null;
        Parser parser = (Parser)this.parserPool.get();
        boolean madeNew = false;
        if (parser == null) {
            this.error("Runtime : ran out of parsers. Creating new.   Please increment the parser.pool.size property. The current value is too small.");
            parser = this.createNewParser();
            if (parser != null) {
                madeNew = true;
            }
        }
        if (parser != null) {
            try {
                if (dumpNamespace) {
                    this.dumpVMNamespace(templateName);
                }
                ast = parser.parse(reader, templateName);
            }
            finally {
                if (!madeNew) {
                    this.parserPool.put(parser);
                }
            }
        } else {
            this.error("Runtime : ran out of parsers and unable to create more.");
        }
        return ast;
    }

    @Override
    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getTemplate(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    @Override
    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (Template)this.resourceManager.getResource(name, 1, encoding);
    }

    @Override
    public ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getContent(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    @Override
    public ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (ContentResource)this.resourceManager.getResource(name, 2, encoding);
    }

    @Override
    public String getLoaderNameForResource(String resourceName) {
        return this.resourceManager.getLoaderNameForResource(resourceName);
    }

    private boolean showStackTrace() {
        if (this.configuration.isInitialized()) {
            return this.getBoolean("runtime.log.warn.stacktrace", false);
        }
        return false;
    }

    private void log(int level, Object message) {
        String out = message instanceof Throwable && this.showStackTrace() ? StringUtils.stackTrace((Throwable)message) : message.toString();
        this.logSystem.logVelocityMessage(level, out);
    }

    @Override
    public void warn(Object message) {
        this.log(2, message);
    }

    @Override
    public void info(Object message) {
        this.log(1, message);
    }

    @Override
    public void error(Object message) {
        this.log(3, message);
    }

    @Override
    public void debug(Object message) {
        this.log(0, message);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.configurationCache.getString(key, defaultValue);
    }

    @Override
    public Directive getVelocimacro(String vmName, String templateName) {
        return this.vmFactory.getVelocimacro(vmName, templateName);
    }

    @Override
    public boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        return this.vmFactory.addVelocimacro(name, macro, argArray, sourceTemplate);
    }

    @Override
    public boolean isVelocimacro(String vmName, String templateName) {
        return this.vmFactory.isVelocimacro(vmName, templateName);
    }

    @Override
    public boolean dumpVMNamespace(String namespace) {
        return this.vmFactory.dumpVMNamespace(namespace);
    }

    @Override
    public String getString(String key) {
        return this.configurationCache.getString(key, null);
    }

    @Override
    public int getInt(String key) {
        return this.configurationCache.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.configurationCache.getInt(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return this.configurationCache.getBoolean(key, def);
    }

    @Override
    public ExtendedProperties getConfiguration() {
        return this.configuration;
    }

    @Override
    public Introspector getIntrospector() {
        return this.introspector;
    }

    @Override
    public Object getApplicationAttribute(Object key) {
        return this.applicationAttributes.get(key);
    }

    public Object setApplicationAttribute(Object key, Object o) {
        return this.applicationAttributes.put(key, o);
    }

    @Override
    public Uberspect getUberspect() {
        return this.uberSpect;
    }

    final class ConfigurationCache {
        private final ConcurrentMap<String, Object> map = CopyOnWriteMap.newHashMap();

        ConfigurationCache() {
        }

        boolean getBoolean(final String key, final boolean defaultValue) {
            return this.get(key, defaultValue, new Closure<Boolean>(){

                @Override
                public Boolean get() {
                    return RuntimeInstance.this.configuration.getBoolean(key, defaultValue);
                }
            });
        }

        public Object getProperty(final String key) {
            return this.get(key, null, new Closure<Object>(){

                @Override
                public Object get() {
                    return RuntimeInstance.this.configuration.getProperty(key);
                }
            });
        }

        public String getString(final String key, final String defaultValue) {
            return this.get(key, defaultValue, new Closure<String>(){

                @Override
                public String get() {
                    return RuntimeInstance.this.configuration.getString(key, defaultValue);
                }
            });
        }

        int getInt(final String key, final int defaultValue) {
            return this.get(key, defaultValue, new Closure<Integer>(){

                @Override
                public Integer get() {
                    return RuntimeInstance.this.configuration.getInteger(key, defaultValue);
                }
            });
        }

        <T> T get(String key, T defaultValue, Closure<T> getter) {
            Object result = this.map.get(key);
            while (result == null) {
                if (!RuntimeInstance.this.configuration.containsKey((Object)key)) {
                    return defaultValue;
                }
                if (!RuntimeInstance.this.initialized) {
                    return getter.get();
                }
                this.map.putIfAbsent(key, getter.get());
                result = this.map.get(key);
            }
            return (T)result;
        }
    }

    static interface Closure<T> {
        public T get();
    }
}

