/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.juc;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class MultiTenantExecutors {
    private static final Logger log = Logger.getLogger(MultiTenantExecutors.class);

    public static ExecutorService wrap(ExecutorService executorService) {
        if (MultiTenantContext.isEnabled()) {
            return new MultiTenantExecutorServiceDelegate(executorService);
        }
        return executorService;
    }

    public static ScheduledExecutorService wrap(ScheduledExecutorService scheduledExecutorService) {
        if (MultiTenantContext.isEnabled()) {
            return new MultiTenantScheduledExecutorServiceDelegate(scheduledExecutorService);
        }
        return scheduledExecutorService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> target;
        private final Tenant tenant;

        private WrappedCallable(Callable<T> target) {
            this.target = target;
            this.tenant = MultiTenantContext.getTenantReference().get();
        }

        @Override
        public T call() throws Exception {
            return (T)MultiTenantContext.getManager().callForTenant(this.tenant, this.target, false);
        }
    }

    private static class WrappedRunnable
    implements Runnable {
        private final Runnable target;
        private final Tenant tenant;

        private WrappedRunnable(Runnable target) {
            this.target = target;
            this.tenant = MultiTenantContext.getTenantReference().get();
        }

        public void run() {
            MultiTenantContext.getManager().runForTenant(this.tenant, this.target, false);
        }

        public Runnable getTarget() {
            return this.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiTenantExecutorServiceDelegate
    extends AbstractExecutorService {
        private final ExecutorService target;

        private MultiTenantExecutorServiceDelegate(ExecutorService target) {
            this.target = target;
        }

        @Override
        public void shutdown() {
            this.target.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> wrappedRunnables = this.target.shutdownNow();
            ArrayList<Runnable> results = new ArrayList<Runnable>(wrappedRunnables.size());
            for (Runnable runnable : wrappedRunnables) {
                if (runnable instanceof WrappedRunnable) {
                    results.add(((WrappedRunnable)runnable).getTarget());
                    continue;
                }
                results.add(runnable);
            }
            return results;
        }

        @Override
        public boolean isShutdown() {
            return this.target.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.target.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.target.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.target.execute(new WrappedRunnable(command));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiTenantScheduledExecutorServiceDelegate
    extends MultiTenantExecutorServiceDelegate
    implements ScheduledExecutorService {
        private final ScheduledExecutorService target;

        private MultiTenantScheduledExecutorServiceDelegate(ScheduledExecutorService target) {
            super(target);
            this.target = target;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.target.schedule(new WrappedRunnable(command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.target.schedule(new WrappedCallable(callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.target.scheduleAtFixedRate(new WrappedRunnable(command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.target.scheduleWithFixedDelay(new WrappedRunnable(command), initialDelay, delay, unit);
        }
    }
}

