/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.impl.util;

import alt.javax.mail.internet.MimeMessage;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailUtils;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang.StringUtils;

public class MessageCreator {
    public void updateMimeMessage(Email email, String defaultFrom, String prefix, MimeMessage message) throws MailException, MessagingException, UnsupportedEncodingException {
        InternetAddress internetAddress;
        String from = StringUtils.trim((String)email.getFrom());
        String fromName = email.getFromName();
        String to = email.getTo();
        String cc = email.getCc();
        String bcc = email.getBcc();
        String replyTo = email.getReplyTo();
        String inReplyTo = email.getInReplyTo();
        String subject = email.getSubject();
        String body = email.getBody();
        String mimeType = email.getMimeType();
        String encoding = email.getEncoding();
        Map headers = email.getHeaders();
        Multipart multipart = email.getMultipart();
        if (StringUtils.isBlank((String)StringUtils.trim((String)to)) && StringUtils.isBlank((String)StringUtils.trim((String)cc)) && StringUtils.isBlank((String)StringUtils.trim((String)bcc))) {
            throw new MailException("Tried to send mail (" + subject + ") with no recipients.");
        }
        message.setSentDate(Calendar.getInstance().getTime());
        if (to != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])MailUtils.parseAddresses(to));
        }
        if (cc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])MailUtils.parseAddresses(cc));
        }
        if (bcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])MailUtils.parseAddresses(bcc));
        }
        if (replyTo != null) {
            message.setReplyTo((Address[])MailUtils.parseAddresses(replyTo));
        }
        if (inReplyTo != null) {
            message.setHeader("In-Reply-To", inReplyTo);
        }
        if (StringUtils.isNotBlank((String)from)) {
            internetAddress = new InternetAddress(from);
            if (StringUtils.isNotBlank((String)fromName) && internetAddress.getPersonal() == null) {
                if (encoding != null) {
                    internetAddress.setPersonal(fromName, encoding);
                } else {
                    internetAddress.setPersonal(fromName);
                }
            }
            message.setFrom((Address)internetAddress);
        } else if (StringUtils.isNotBlank((String)defaultFrom)) {
            internetAddress = new InternetAddress(defaultFrom);
            if (StringUtils.isNotBlank((String)fromName) && internetAddress.getPersonal() == null) {
                if (encoding != null) {
                    internetAddress.setPersonal(fromName, encoding);
                } else {
                    internetAddress.setPersonal(fromName);
                }
            }
            message.setFrom((Address)internetAddress);
        } else {
            throw new MailException("Tried to send mail (" + subject + ") from no one (no 'from' and 'default from' specified).");
        }
        String fullSubject = subject;
        if (StringUtils.isNotBlank((String)prefix)) {
            fullSubject = prefix + " " + fullSubject;
        }
        if (encoding != null) {
            message.setSubject(fullSubject, encoding);
        } else {
            message.setSubject(fullSubject);
        }
        String mimeTypeAndEncoding = mimeType;
        if (encoding != null) {
            mimeTypeAndEncoding = mimeTypeAndEncoding + "; charset=" + encoding + "";
        }
        if (multipart != null) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)body, mimeTypeAndEncoding);
            messageBodyPart.setDisposition("inline");
            multipart.addBodyPart((BodyPart)messageBodyPart, 0);
            message.setContent(multipart);
        } else {
            message.setContent((Object)body, mimeTypeAndEncoding);
        }
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                message.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

