/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl.datastore;

import com.atlassian.multitenant.CustomConfigHandler;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.impl.DefaultTenant;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import com.atlassian.multitenant.impl.MultiTenantParser;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMultiTenantDatastore
implements MultiTenantDatastore,
MultiTenantParser {
    private final Map<String, CustomConfigHandler<?>> handlers;
    private final File configFile;
    private final Map<String, Tenant> tenants = CopyOnWriteMap.newHashMap();
    private final Map<String, Tenant> tenantsByHostname = CopyOnWriteMap.newHashMap();
    private static final Logger log = Logger.getLogger(XmlMultiTenantDatastore.class);

    public XmlMultiTenantDatastore(Map<String, CustomConfigHandler<?>> handlers, File configFile) {
        this.handlers = handlers;
        this.configFile = configFile;
        if (configFile != null) {
            this.loadFrom(configFile);
        }
    }

    @Override
    public Tenant get(String name) {
        return this.tenants.get(name);
    }

    @Override
    public Collection<Tenant> getAll() {
        return Collections.unmodifiableCollection(this.tenants.values());
    }

    @Override
    public Tenant getByHostname(String hostname) {
        return this.tenantsByHostname.get(hostname);
    }

    void loadFrom(File file) {
        if (!file.exists()) {
            FileWriter writer = null;
            try {
                file.getParentFile().mkdirs();
                writer = new FileWriter(file);
                writer.write("<multitenant/>");
            }
            catch (IOException ioe) {
                try {
                    throw new IllegalArgumentException(ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        Document document = this.loadDocument(file);
        Element root = document.getRootElement();
        for (Element tenantElement : root.elements("tenant")) {
            Tenant tenant = this.parseTenant(tenantElement);
            this.addTenantInternal(tenant);
        }
    }

    private void addTenantInternal(Tenant tenant) {
        this.tenants.put(tenant.getName(), tenant);
        for (String hostname : tenant.getHostnames()) {
            if (this.tenantsByHostname.containsKey(hostname)) {
                log.warn((Object)("Duplicate hostname detected in config: " + hostname));
            }
            this.tenantsByHostname.put(hostname, tenant);
        }
    }

    @Override
    public synchronized void addTenant(Tenant tenant) {
        this.addTenantInternal(tenant);
        this.save();
    }

    @Override
    public synchronized void removeTenant(Tenant tenant) {
        for (String hostname : tenant.getHostnames()) {
            this.tenantsByHostname.remove(hostname);
        }
        this.tenants.remove(tenant.getName());
        this.save();
    }

    @Override
    public Tenant parseTenant(Reader reader) throws IOException {
        SAXReader xmlReader = new SAXReader();
        try {
            Document document = xmlReader.read(reader);
            return this.parseTenant(document.getRootElement());
        }
        catch (DocumentException e) {
            throw new RuntimeException("Error parsing XML", e);
        }
    }

    private Tenant parseTenant(Element tenant) {
        String name = tenant.attributeValue("name");
        HashMap customConfig = new HashMap();
        for (Element config : tenant.elements()) {
            String configName = config.getName();
            if (configName.equals("hostnames") || configName.equals("homeDir")) continue;
            CustomConfigHandler<?> handler = this.handlers.get(configName);
            if (handler != null) {
                customConfig.put(handler.getBeanClass(), handler.parse(config));
                continue;
            }
            log.error((Object)("Unknown config item in multi tenant config file: " + configName));
        }
        HashSet<String> hostnames = new HashSet<String>();
        Element hostnamesElement = tenant.element("hostnames");
        if (hostnamesElement != null) {
            for (Element hostnameElement : hostnamesElement.elements("hostname")) {
                hostnames.add(hostnameElement.getTextTrim());
            }
        }
        String homeDir = tenant.elementTextTrim("homeDir");
        return new DefaultTenant(name, hostnames, homeDir, customConfig);
    }

    private void save() {
        if (this.configFile != null) {
            this.saveTo(this.configFile);
        }
    }

    void saveTo(File file) {
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement("multitenant");
        for (Tenant tenant : this.getAll()) {
            Element tenantElement = rootElement.addElement("tenant");
            tenantElement.addAttribute("name", tenant.getName());
            Element hostnamesElement = tenantElement.addElement("hostnames");
            for (String hostname : tenant.getHostnames()) {
                Element hostnameElement = hostnamesElement.addElement("hostname");
                hostnameElement.setText(hostname);
            }
            Element homeDirElement = tenantElement.addElement("homeDir");
            homeDirElement.setText(tenant.getHomeDir());
            for (Map.Entry<String, CustomConfigHandler<?>> handler : this.handlers.entrySet()) {
                Object customConfig = tenant.getConfig(handler.getValue().getBeanClass());
                if (customConfig == null) continue;
                Element customConfigElement = tenantElement.addElement(handler.getKey());
                CustomConfigHandler<?> objectHandler = handler.getValue();
                objectHandler.writeTo(customConfigElement, customConfig);
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
        }
        catch (IOException ioe) {
            try {
                throw new IllegalArgumentException("Error writing config file", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document loadDocument(File file) {
        Document document;
        FileReader fileReader = null;
        SAXReader xmlReader = new SAXReader();
        try {
            fileReader = new FileReader(file);
            document = xmlReader.read((Reader)fileReader);
        }
        catch (DocumentException de) {
            try {
                throw new IllegalArgumentException("Error parsing config file", de);
                catch (FileNotFoundException fnfe) {
                    throw new IllegalArgumentException("Error opening config file", fnfe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return document;
    }
}

