/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserCredentialHistoryEntity {
    static final String ENTITY = "UserCredentialHistory";
    static final String ID = "id";
    static final String USER_ID = "userId";
    static final String CREDENTIAL = "credential";
    static final String LIST_INDEX = "listIndex";
    private static Function<GenericValue, PasswordCredential> TO_CREDENTIAL = new Function<GenericValue, PasswordCredential>(){

        public PasswordCredential apply(GenericValue genericValue) {
            return new PasswordCredential(String.valueOf(genericValue.get(UserCredentialHistoryEntity.CREDENTIAL)), true);
        }
    };

    static Map<String, Object> getData(Long userId, String credential, Integer order) {
        HashMap data = Maps.newHashMap();
        data.put(USER_ID, userId);
        data.put(CREDENTIAL, credential);
        data.put(LIST_INDEX, order);
        return data;
    }

    static List<PasswordCredential> toCredentials(List<GenericValue> credentialGenericValues) {
        return Lists.transform(credentialGenericValues, TO_CREDENTIAL);
    }

    private UserCredentialHistoryEntity() {
    }
}

