/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.spi.link;

import com.atlassian.applinks.api.ApplicationLink;
import com.google.common.base.Preconditions;
import java.net.URI;

public class ApplicationLinkDetails {
    private final String name;
    private final URI displayUrl;
    private final URI rpcUrl;
    private final boolean isPrimary;

    private ApplicationLinkDetails(String name, URI displayUrl, URI rpcUrl, boolean isPrimary) {
        this.name = name;
        this.displayUrl = displayUrl;
        this.rpcUrl = rpcUrl;
        this.isPrimary = isPrimary;
    }

    public String getName() {
        return this.name;
    }

    public URI getDisplayUrl() {
        return this.displayUrl;
    }

    public URI getRpcUrl() {
        return this.rpcUrl;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationLinkDetails details) {
        Builder builder = new Builder();
        builder.displayUrl = details.displayUrl;
        builder.rpcUrl = details.rpcUrl;
        builder.name = details.name;
        builder.isPrimary = details.isPrimary;
        return builder;
    }

    public static Builder builder(ApplicationLink applicationLink) {
        Builder builder = new Builder();
        builder.displayUrl = applicationLink.getDisplayUrl();
        builder.rpcUrl = applicationLink.getRpcUrl();
        builder.name = applicationLink.getName();
        builder.isPrimary = applicationLink.isPrimary();
        return builder;
    }

    public static class Builder {
        private String name;
        private URI displayUrl;
        private URI rpcUrl;
        private boolean isPrimary;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayUrl(URI url) {
            this.displayUrl = url;
            return this;
        }

        public Builder rpcUrl(URI url) {
            this.rpcUrl = url;
            return this;
        }

        public Builder isPrimary(boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public ApplicationLinkDetails build() {
            if (this.rpcUrl == null) {
                this.rpcUrl = this.displayUrl;
            } else if (this.displayUrl == null) {
                this.displayUrl = this.rpcUrl;
            }
            if (this.rpcUrl == null) {
                throw new NullPointerException("either displayUrl or rpcUrl must be set before build()");
            }
            return new ApplicationLinkDetails((String)Preconditions.checkNotNull((Object)this.name, (Object)"name"), (URI)Preconditions.checkNotNull((Object)this.displayUrl, (Object)"displayUrl"), (URI)Preconditions.checkNotNull((Object)this.rpcUrl, (Object)"rpcUrl"), this.isPrimary);
        }
    }
}

