/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.sql.DataSourceWrapper;

public class DriverTag
extends TagSupport {
    private static final String DRIVER_CLASS_NAME = "javax.servlet.jsp.jstl.sql.driver";
    private static final String JDBC_URL = "javax.servlet.jsp.jstl.sql.jdbcURL";
    private static final String USER_NAME = "javax.servlet.jsp.jstl.sql.userName";
    private static final String PASSWORD = "javax.servlet.jsp.jstl.sql.password";
    private String driverClassName;
    private String jdbcURL;
    private String scope = "page";
    private String userName;
    private String var;

    public void setDriver(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setScope(String scopeName) {
        this.scope = scopeName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        DataSourceWrapper ds = new DataSourceWrapper();
        try {
            ds.setDriverClassName(this.getDriverClassName());
        }
        catch (Exception e) {
            throw new JellyTagException("Invalid driver class name: " + e.getMessage());
        }
        ds.setJdbcURL(this.getJdbcURL());
        ds.setUserName(this.getUserName());
        ds.setPassword(this.getPassword());
        this.context.setVariable(this.var, (Object)ds);
    }

    private String getDriverClassName() {
        if (this.driverClassName != null) {
            return this.driverClassName;
        }
        return this.getInitParameter(DRIVER_CLASS_NAME);
    }

    private String getJdbcURL() {
        if (this.jdbcURL != null) {
            return this.jdbcURL;
        }
        return this.getInitParameter(JDBC_URL);
    }

    private String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        return this.getInitParameter(USER_NAME);
    }

    private String getPassword() {
        return this.getInitParameter(PASSWORD);
    }

    protected String getInitParameter(String key) {
        return "";
    }
}

