/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.selector;

import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.UrlRewriter;
import com.atlassian.gzipfilter.selector.GzipCompatibilitySelector;
import com.atlassian.gzipfilter.selector.PatternMatcher;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UrlRewriteGzipCompatibilitySelector
implements GzipCompatibilitySelector {
    private static final Logger log = Logger.getLogger((Class)UrlRewriteGzipCompatibilitySelector.class);
    private static final String GZIP_RESPONSE = "gzipResponse";
    private static final String GZIP_MIME_TYPES = "gzipMimeTypes";
    private final UrlRewriter rewriter;
    private final HttpServletRequest request;
    private final PatternMatcher patternMatcher = new PatternMatcher();

    public UrlRewriteGzipCompatibilitySelector(UrlRewriter rewriter, HttpServletRequest request) {
        this.rewriter = rewriter;
        this.request = request;
        this.processUrlRewriteRules(request);
    }

    public boolean shouldGzip(String contentType) {
        String mimeTypesToGzip = (String)this.request.getAttribute(GZIP_MIME_TYPES);
        return this.patternMatcher.matches(contentType, mimeTypesToGzip);
    }

    public boolean shouldGzip() {
        return !"false".equalsIgnoreCase(String.valueOf(this.request.getAttribute(GZIP_RESPONSE)));
    }

    private void processUrlRewriteRules(HttpServletRequest request) {
        if (this.rewriter != null) {
            try {
                this.rewriter.processRequest(request, null);
            }
            catch (Exception e) {
                log.error((Object)"Error whilst processing request to see if it should be gzipped ", (Throwable)e);
            }
        }
    }
}

