/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter;

import com.atlassian.gzipfilter.GzipResponseWrapper;
import com.atlassian.gzipfilter.RoutablePrintWriter;
import com.atlassian.gzipfilter.RoutableServletOutputStream;
import com.atlassian.gzipfilter.selector.GzipCompatibilitySelector;
import com.atlassian.gzipfilter.util.HttpContentType;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SelectingResponseWrapper
extends HttpServletResponseWrapper {
    private final RoutablePrintWriter routablePrintWriter;
    private final RoutableServletOutputStream routableServletOutputStream;
    private final GzipCompatibilitySelector compatibilitySelector;
    private final GzipResponseWrapper wrappedResponse;
    private boolean gzippablePage = false;

    public SelectingResponseWrapper(HttpServletResponse unWrappedResponse, GzipCompatibilitySelector compatibilitySelector, String defaultEncoding) {
        super(unWrappedResponse);
        this.wrappedResponse = new GzipResponseWrapper(unWrappedResponse, defaultEncoding);
        this.compatibilitySelector = compatibilitySelector;
        this.routablePrintWriter = new RoutablePrintWriter(new RoutablePrintWriterDestinationFactory((ServletResponse)unWrappedResponse));
        this.routableServletOutputStream = new RoutableServletOutputStream(new RoutableServletOutputStreamDestinationFactory((ServletResponse)unWrappedResponse));
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (type != null) {
            HttpContentType httpContentType = new HttpContentType(type);
            if (this.compatibilitySelector.shouldGzip(httpContentType.getType())) {
                this.activateGzip(httpContentType.getEncoding());
            } else {
                this.deactivateGzip();
            }
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (!this.wrappedResponse.isCommitted() && this.gzippablePage) {
            this.deactivateGzip();
        }
        super.sendRedirect(location);
    }

    public void setStatus(int statusCode, String sm) {
        super.setStatus(statusCode, sm);
        if (!this.shouldGzip(statusCode)) {
            this.deactivateGzip();
        }
    }

    public void setStatus(int statusCode) {
        super.setStatus(statusCode);
        if (!this.shouldGzip(statusCode)) {
            this.deactivateGzip();
        }
    }

    private boolean shouldGzip(int statusCode) {
        return statusCode != 204 && statusCode != 304;
    }

    private void activateGzip(String encoding) {
        if (this.gzippablePage) {
            return;
        }
        if (encoding != null) {
            this.wrappedResponse.setEncoding(encoding);
        }
        if (!this.wrappedResponse.isCommitted()) {
            this.wrappedResponse.setHeader("Content-Encoding", "gzip");
            this.wrappedResponse.setHeader("Vary", "User-Agent");
        }
        this.routablePrintWriter.updateDestination(new RoutablePrintWriterDestinationFactory((ServletResponse)this.wrappedResponse));
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStreamDestinationFactory((ServletResponse)this.wrappedResponse));
        this.gzippablePage = true;
    }

    private void deactivateGzip() {
        this.gzippablePage = false;
        if (!this.wrappedResponse.isCommitted()) {
            this.wrappedResponse.setHeader("Content-Encoding", "");
            this.wrappedResponse.setHeader("Vary", "");
        }
        this.routablePrintWriter.updateDestination(new RoutablePrintWriterDestinationFactory(this.getResponse()));
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStreamDestinationFactory(this.getResponse()));
    }

    public void setContentLength(int contentLength) {
        if (!this.gzippablePage) {
            super.setContentLength(contentLength);
        }
    }

    public void flushBuffer() throws IOException {
        if (!this.gzippablePage) {
            super.flushBuffer();
        }
    }

    public void setHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.gzippablePage || !name.toLowerCase().equals("content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.gzippablePage || !name.toLowerCase().equals("content-length")) {
            super.addHeader(name, value);
        }
    }

    public ServletOutputStream getOutputStream() {
        return this.routableServletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.routablePrintWriter;
    }

    public void finishResponse() {
        if (this.gzippablePage) {
            this.wrappedResponse.finishResponse();
        }
    }

    private static class RoutableServletOutputStreamDestinationFactory
    implements RoutableServletOutputStream.DestinationFactory {
        private final ServletResponse servletResponse;

        public RoutableServletOutputStreamDestinationFactory(ServletResponse servletResponse) {
            this.servletResponse = servletResponse;
        }

        public ServletOutputStream create() throws IOException {
            return this.servletResponse.getOutputStream();
        }
    }

    private static class RoutablePrintWriterDestinationFactory
    implements RoutablePrintWriter.DestinationFactory {
        private final ServletResponse servletResponse;

        public RoutablePrintWriterDestinationFactory(ServletResponse servletResponse) {
            this.servletResponse = servletResponse;
        }

        public PrintWriter activateDestination() throws IOException {
            return this.servletResponse.getWriter();
        }
    }
}

